/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.template.wizard.apply;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.template.ITemplateWizard;
import com.sap.ide.tools.core.template.TemplatePlugin;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateExtender;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateManager;
import com.sap.ide.tools.core.template.generation.GenerationStartup;
import com.sap.ide.tools.core.template.service.ITemplateApplicable;
import com.sap.ide.tools.core.template.textpool.TextPool;
import com.sap.ide.tools.core.template.wizard.apply.ApplyTemplateSelectionPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ApplyTemplateWizard
extends Wizard {
    private DevelopmentObject mContainingObject = null;
    private TemplateManager mManager = null;
    private TemplateExtender[] mTemplateExtenders = null;
    private ApplyTemplateSelectionPage mTemplateSelectionPage = null;

    public ApplyTemplateWizard(DevelopmentObject containingObject) {
        this.mManager = new TemplateManager(containingObject);
        this.mTemplateExtenders = this.mManager.getTemplateExtenders();
        this.mContainingObject = containingObject;
        this.setWindowTitle(TextPool.getInstance().getText(5));
        int i = 0;
        while (i < this.mTemplateExtenders.length) {
            ITemplateWizard wizard = this.mTemplateExtenders[i].getWizardClass();
            wizard.setContainingObject(this.mContainingObject);
            if (wizard != null) {
                wizard.setContainer(this.getContainer());
            }
            ++i;
        }
    }

    public boolean performFinish() {
        ITemplateApplicable lApplicable;
        TemplateExtender lSelectedTemplate = this.mManager.getSelectedTemplate();
        if (lSelectedTemplate != null && (lApplicable = lSelectedTemplate.getApplicableClass()).isGenerationPossible(this.mContainingObject, lSelectedTemplate.getDataClass()) && lApplicable.makeGenerationPossible(this.mContainingObject, lSelectedTemplate.getDataClass())) {
            try {
                GenerationStartup.generate(this.mManager, this.mContainingObject);
            }
            catch (Throwable t) {
                TemplatePlugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", "Error in template generation", t, false);
            }
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(true);
        this.mTemplateSelectionPage = new ApplyTemplateSelectionPage(this.mTemplateExtenders, this.mContainingObject, this.mManager);
        this.addPage((IWizardPage)this.mTemplateSelectionPage);
        int i = 0;
        while (i < this.mTemplateExtenders.length) {
            ITemplateWizard wizard = this.mTemplateExtenders[i].getWizardClass();
            if (wizard != null) {
                try {
                    wizard.addPages();
                    IWizardPage[] pages = wizard.getPages();
                    int j = 0;
                    while (j < pages.length) {
                        this.addPage(pages[j]);
                        ++j;
                    }
                }
                catch (Throwable t) {
                    TemplatePlugin.internalError(((Object)((Object)this)).getClass(), "addPages()", "Error when adding wizard pages", t, false);
                }
            }
            ++i;
        }
    }

    public boolean canFinish() {
        return this.mManager.getSelectedTemplate() != null && this.mManager.getSelectedTemplate().getDataClass() != null && this.mManager.getSelectedTemplate().getDataClass().isValid();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage wizardPage = super.getNextPage(this.getContainer().getCurrentPage());
        if (wizardPage == null) {
            return null;
        }
        if (!(wizardPage instanceof ApplyTemplateSelectionPage)) {
            int i = 0;
            while (i < this.mTemplateExtenders.length) {
                ITemplateWizard wizard = this.mTemplateExtenders[i].getWizardClass();
                if (wizard.getPage(this.getContainer().getCurrentPage().getName()) != null && wizard.getPage(wizardPage.getName()) == null) {
                    return null;
                }
                ++i;
            }
        }
        return wizardPage;
    }
}

