/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.template.wizard.apply;

import com.sap.ide.metamodel.common.CommonDevelopmentObject;
import com.sap.ide.metamodel.common.template.EmbeddedTemplateInstance;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.template.ITemplateWizard;
import com.sap.ide.tools.core.template.TemplatePlugin;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateExtender;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateManager;
import com.sap.ide.tools.core.template.textpool.TextPool;
import com.sap.ide.tools.core.template.wizard.apply.ApplyTemplateSelectionListener;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplyTemplateSelectionPage
extends WizardPage {
    private TemplateExtender[] mTemplateExtenders = null;
    private TemplateManager mManager = null;
    private ISapTableViewer mTableViewer = null;
    private TemplateExtender mSelectedTemplateExtender = null;
    private Text mText = null;
    private Label mLabel = null;
    private static int mIndex = 0;

    public ApplyTemplateSelectionPage(TemplateExtender[] templateExtenders, DevelopmentObject containingObject, TemplateManager manager) {
        super(TextPool.getInstance().getText(6));
        this.mTemplateExtenders = templateExtenders;
        this.mManager = manager;
        this.setTitle(TextPool.getInstance().getText(6));
        this.setDescription(TextPool.getInstance().getText(7));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.setControl((Control)root);
        Composite lGlp = new Composite(root, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        lGlp.setLayout((Layout)gridLayout);
        GridData lCompositeData = new GridData(768);
        lGlp.setLayoutData((Object)lCompositeData);
        this.mLabel = new Label(lGlp, 0);
        this.mLabel.setText(TextPool.getInstance().getText(8));
        this.mText = new Text(lGlp, 2048);
        GridData lTextData = new GridData(768);
        this.mText.setLayoutData((Object)lTextData);
        if (this.mTemplateExtenders.length > 0) {
            this.mSelectedTemplateExtender = this.mTemplateExtenders[0];
            String lUniqueName = this.getUniqueName(this.mSelectedTemplateExtender.getContainingObject(), this.mSelectedTemplateExtender.getName());
            this.mSelectedTemplateExtender.getDataClass().setName(lUniqueName);
            this.mText.setText(lUniqueName);
        }
        this.mText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ApplyTemplateSelectionPage.this.getWizard().getContainer().updateButtons();
                if (ApplyTemplateSelectionPage.this.mSelectedTemplateExtender != null) {
                    ApplyTemplateSelectionPage.this.mSelectedTemplateExtender.getDataClass().setName(ApplyTemplateSelectionPage.this.mText.getText());
                }
            }
        });
        ScrolledComposite lScrollContainer = new ScrolledComposite(root, 2816);
        GridData gdsc = new GridData(1808);
        gdsc.heightHint = 200;
        gdsc.widthHint = 450;
        lScrollContainer.setLayoutData((Object)gdsc);
        Composite lScrollable = new Composite((Composite)lScrollContainer, 0);
        lScrollContainer.setContent((Control)lScrollable);
        GridLayout grid = new GridLayout();
        lScrollable.setLayout((Layout)grid);
        grid.numColumns = 3;
        int i = 0;
        while (i < this.mTemplateExtenders.length) {
            Composite lOneItem = new Composite(lScrollable, 0);
            GridData lOneGridData = new GridData(2);
            lOneItem.setLayoutData((Object)lOneGridData);
            GridLayout lInnerGridLayout = new GridLayout();
            lOneItem.setLayout((Layout)lInnerGridLayout);
            Image lImage = TemplatePlugin.getImage(this.mTemplateExtenders[i]);
            Button lTemplateButton = new Button(lOneItem, 0x800000);
            GridData lImageGridData = new GridData(64);
            lImageGridData.heightHint = 60;
            lTemplateButton.setLayoutData((Object)lImageGridData);
            lTemplateButton.setImage(lImage);
            lTemplateButton.setToolTipText(this.mTemplateExtenders[i].getName());
            lTemplateButton.addSelectionListener((SelectionListener)new ApplyTemplateSelectionListener(this, this.mTemplateExtenders[i]));
            Label lLabel = new Label(lOneItem, 0x1000040);
            lLabel.setText(this.mTemplateExtenders[i].getName());
            GridData lLabelGridData = new GridData(64);
            lLabelGridData.widthHint = 130;
            lLabel.setLayoutData((Object)lLabelGridData);
            ++i;
        }
        lScrollable.setSize(lScrollable.computeSize(-1, -1));
        lScrollContainer.setSize(lScrollContainer.computeSize(450, 200));
        this.validatePage();
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public TemplateExtender getSelectedTemplateExtender() {
        return this.mSelectedTemplateExtender;
    }

    private boolean validatePage() {
        CommonDevelopmentObject commonObject;
        EmbeddedTemplateInstance instance;
        if (this.mSelectedTemplateExtender == null) {
            this.setErrorMessage(TextPool.getInstance().getText(9));
            return false;
        }
        String text = this.mText.getText();
        if (this.mSelectedTemplateExtender.getContainingObject() instanceof CommonDevelopmentObject && (instance = (commonObject = (CommonDevelopmentObject)this.mSelectedTemplateExtender.getContainingObject()).getTemplateInstance(text)) != null) {
            this.setErrorMessage(TextPool.getInstance().getText(15));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        ITemplateWizard wizard;
        IWizardPage page = null;
        if (this.mSelectedTemplateExtender != null && (wizard = this.mSelectedTemplateExtender.getWizardClass()) != null) {
            this.mManager.setSelectedTemplate(this.mSelectedTemplateExtender);
            page = wizard.getStartingPage();
        }
        return page;
    }

    public void selectTemplate(TemplateExtender extender) {
        this.mSelectedTemplateExtender = extender;
        String lUniqueName = this.getUniqueName(this.mSelectedTemplateExtender.getContainingObject(), this.mSelectedTemplateExtender.getName());
        this.mSelectedTemplateExtender.getDataClass().setName(lUniqueName);
        this.mText.setText(lUniqueName);
        this.getContainer().updateButtons();
    }

    public String getUniqueName(DevelopmentObject object, String name) {
        String lName = name;
        if (object instanceof CommonDevelopmentObject) {
            CommonDevelopmentObject commonObject = (CommonDevelopmentObject)object;
            while (commonObject.getTemplateInstance(lName) != null) {
                lName = lName + mIndex;
                ++mIndex;
            }
        }
        return lName;
    }

    public boolean canFlipToNextPage() {
        return this.validatePage();
    }
}

