/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.template.generation;

import com.sap.ide.metamodel.common.CommonDevelopmentObject;
import com.sap.ide.metamodel.common.template.EmbeddedTemplateInstance;
import com.sap.ide.metamodel.common.template.TemplateInstance;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.tools.core.template.ITemplateWizardListener;
import com.sap.ide.tools.core.template.TemplatePlugin;
import com.sap.ide.tools.core.template.extensionmanagement.GenerationExtender;
import com.sap.ide.tools.core.template.extensionmanagement.InstanceExtender;
import com.sap.ide.tools.core.template.extensionmanagement.InstanceManager;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateExtender;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateManager;
import com.sap.ide.tools.core.template.generation.GenerationFacade;
import com.sap.ide.tools.core.template.service.IGenerationFacade;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.tools.core.template.service.ITemplateGeneration;
import com.sap.ide.tools.core.template.service.NatureEnum;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class GenerationStartup {
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_GENERATOR_CLASS = "generatorClass";

    protected GenerationStartup() {
    }

    public static void generate(TemplateManager manager, DevelopmentObject object) {
        ITemplateGeneration lClassInstance;
        GenerationExtender generationExtender = manager.getCorrespondingGenerationExtender();
        if (generationExtender != null && (lClassInstance = generationExtender.getGenerationClass()) instanceof ITemplateGeneration) {
            GenerationStartup.beforeGeneration();
            ITemplateData templateData = manager.getSelectedTemplate().getDataClass();
            ITemplateGeneration templateGeneration = lClassInstance;
            if (templateGeneration.check(templateData, object)) {
                MainDevelopmentObject[] MDOs = templateGeneration.getAffectedMDOs(templateData, object);
                TemplateExtender selectedTemplate = manager.getSelectedTemplate();
                GenerationFacade facade = GenerationStartup.getGenerationFacade(selectedTemplate);
                facade.initDependants();
                if (facade.checkWritability(MDOs)) {
                    if (selectedTemplate.getContainingObject() instanceof CommonDevelopmentObject) {
                        CommonDevelopmentObject commonObject = (CommonDevelopmentObject)selectedTemplate.getContainingObject();
                        try {
                            EmbeddedTemplateInstance instance = commonObject.createTemplateInstance(templateData.getName());
                            templateData.setTemplateInstance((TemplateInstance)instance);
                        }
                        catch (CreateException e) {
                            return;
                        }
                    }
                    templateGeneration.generateMetaDataObjects(templateData, object);
                    if (selectedTemplate.getNature() == NatureEnum.GENERATION) {
                        String projectName = object.getRoot().getMetamodel().getName();
                        GenerationStartup.updateGeneratedSources(projectName, facade);
                        facade.setObject(object);
                        facade.setTemplateData(templateData);
                        facade.setTemplate(manager.getSelectedTemplate());
                        templateGeneration.generateCoding((IGenerationFacade)facade);
                        GenerationStartup.updateGeneratedSources(projectName, facade);
                        facade.updateDependant();
                    }
                    GenerationStartup.checkNewFiles(object, templateData, templateGeneration, facade);
                }
            }
            GenerationStartup.afterGeneration();
        }
    }

    private static void checkNewFiles(DevelopmentObject object, ITemplateData templateData, ITemplateGeneration templateGeneration, GenerationFacade facade) {
        MainDevelopmentObject[] createdMDOs = templateGeneration.getCreatedMDOs(templateData, object);
        MainDevelopmentObject[] deletedMDOs = templateGeneration.getDeletedMDOs(templateData, object);
        if (createdMDOs != null && createdMDOs.length > 0 || deletedMDOs != null && deletedMDOs.length > 0) {
            int createdLength = 0;
            int deletedLength = 0;
            if (createdMDOs != null) {
                createdLength = createdMDOs.length;
            }
            if (deletedMDOs != null) {
                deletedLength = deletedMDOs.length;
            }
            if (createdLength + deletedLength > 0) {
                int i;
                MainDevelopmentObject[] newFileArray = new MainDevelopmentObject[createdLength + deletedLength];
                if (createdMDOs != null) {
                    i = 0;
                    while (i < createdLength) {
                        newFileArray[i] = createdMDOs[i];
                        ++i;
                    }
                }
                if (deletedMDOs != null) {
                    i = createdLength;
                    while (i < createdLength + deletedLength) {
                        newFileArray[i] = deletedMDOs[i - createdLength];
                        ++i;
                    }
                }
                facade.checkWritability(newFileArray);
            }
        }
    }

    public static void generate(InstanceManager manager, DevelopmentObject object) {
        ITemplateGeneration lClassInstance;
        GenerationExtender generationExtender = manager.getCorrespondingGenerationExtender();
        if (generationExtender != null && (lClassInstance = generationExtender.getGenerationClass()) instanceof ITemplateGeneration) {
            GenerationStartup.beforeGeneration();
            InstanceExtender instanceExtender = manager.getSelectedInstance();
            ITemplateData templateData = instanceExtender.getDataClass();
            ITemplateGeneration templateGeneration = lClassInstance;
            templateGeneration.generateMetaDataObjects(templateData, object);
            InstanceExtender selectedInstance = manager.getSelectedInstance();
            GenerationFacade facade = GenerationStartup.getGenerationFacade(selectedInstance);
            String projectName = object.getRoot().getMetamodel().getName();
            GenerationStartup.updateGeneratedSources(projectName, facade);
            if (selectedInstance.getNature() == NatureEnum.GENERATION) {
                facade.setObject(object);
                facade.setTemplateData(templateData);
                facade.setInstance(manager.getSelectedInstance());
                templateGeneration.generateCoding((IGenerationFacade)facade);
                GenerationStartup.updateGeneratedSources(projectName, facade);
            }
            GenerationStartup.afterGeneration();
        }
    }

    private static void updateGeneratedSources(String projectName, GenerationFacade facade) {
        MetamodelManager.getMetamodelManager((String)projectName).saveAllMetaData();
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            facade.updateSources(projectName);
        }
        ResourcesPlugin.getWorkspace().checkpoint(false);
    }

    private static void beforeGeneration() {
        ITemplateWizardListener[] listener = TemplateManager.getListener();
        int i = 0;
        while (i < listener.length) {
            listener[i].beforeGeneration();
            ++i;
        }
    }

    private static void afterGeneration() {
        ITemplateWizardListener[] listener = TemplateManager.getListener();
        int i = 0;
        while (i < listener.length) {
            listener[i].afterGeneration();
            ++i;
        }
    }

    private static GenerationFacade getGenerationFacade(InstanceExtender instance) {
        return GenerationStartup.getGenerationFacade(instance.getTemplateExtender());
    }

    private static GenerationFacade getGenerationFacade(TemplateExtender template) {
        TemplatePlugin plugin = TemplatePlugin.getDefault();
        IExtensionPoint extensionPoint = plugin.getDescriptor().getExtensionPoint("TemplateGenerator");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (GenerationStartup.checkExtendingElement(elements[j], template)) {
                        String lClassName = elements[j].getAttribute(ATTRIBUTE_GENERATOR_CLASS);
                        IExtension lDeclExtension = elements[j].getDeclaringExtension();
                        ClassLoader lClassLoader = lDeclExtension.getDeclaringPluginDescriptor().getPluginClassLoader();
                        try {
                            Object lClassInstance = lClassLoader.loadClass(lClassName).newInstance();
                            if (lClassInstance instanceof GenerationFacade) {
                                return (GenerationFacade)lClassInstance;
                            }
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean checkExtendingElement(IConfigurationElement element, TemplateExtender template) {
        return element.getAttribute(ATTRIBUTE_TYPE).equals(template.getType());
    }
}

