/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.template.extensionmanagement;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.template.ITemplateWizardListener;
import com.sap.ide.tools.core.template.TemplatePlugin;
import com.sap.ide.tools.core.template.extensionmanagement.AbstractManager;
import com.sap.ide.tools.core.template.extensionmanagement.GenerationExtender;
import com.sap.ide.tools.core.template.extensionmanagement.TemplateExtender;
import com.sap.ide.tools.core.template.service.ITemplateApplicable;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class TemplateManager
extends AbstractManager {
    private static final String EXTENSION_APPLICABLE_CLASS_NAME = "applicableClass";
    private static TemplateManager mInstance = null;
    private IConfigurationElement[] mExtenders = null;
    private TemplateExtender[] mTemplates = null;
    private TemplateExtender mSelectedTemplate = null;
    private static Vector mListener = new Vector();

    public TemplateManager(DevelopmentObject containingObject) {
        this.mExtenders = this.getValidTemplates(containingObject);
        this.mContainingObject = containingObject;
        this.initializeTemplates();
    }

    private IConfigurationElement[] getValidTemplates(DevelopmentObject containingObject) {
        ArrayList<IConfigurationElement> templateList = new ArrayList<IConfigurationElement>();
        TemplatePlugin plugin = TemplatePlugin.getDefault();
        IExtensionPoint extensionPoint = plugin.getDescriptor().getExtensionPoint("TemplateWizard");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (this.checkExtendingElement(elements[j], containingObject)) {
                        templateList.add(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        IConfigurationElement[] extenders = new IConfigurationElement[templateList.size()];
        extenders = templateList.toArray(extenders);
        return extenders;
    }

    private boolean checkExtendingElement(IConfigurationElement element, DevelopmentObject object) {
        String lClassName = element.getAttribute(EXTENSION_APPLICABLE_CLASS_NAME);
        try {
            IExtension lDeclExtension = element.getDeclaringExtension();
            ClassLoader lClassLoader = lDeclExtension.getDeclaringPluginDescriptor().getPluginClassLoader();
            Object lClassInstance = lClassLoader.loadClass(lClassName).newInstance();
            if (lClassInstance instanceof ITemplateApplicable) {
                ITemplateApplicable applicable = (ITemplateApplicable)lClassInstance;
                return applicable.isApplicable(object);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }

    public GenerationExtender getCorrespondingGenerationExtender() {
        return this.getCorrespondingGenerationExtender(this.mSelectedTemplate);
    }

    private void initializeTemplates() {
        ArrayList<TemplateExtender> templateList = new ArrayList<TemplateExtender>();
        ArrayList typeList = new ArrayList();
        int i = 0;
        while (i < this.mExtenders.length) {
            TemplateExtender extender = new TemplateExtender(this.mExtenders[i], this.mContainingObject);
            if (extender.isValid()) {
                templateList.add(extender);
            }
            ++i;
        }
        this.mTemplates = new TemplateExtender[templateList.size()];
        this.mTemplates = templateList.toArray(this.mTemplates);
    }

    public TemplateExtender[] getTemplateExtenders() {
        return this.mTemplates;
    }

    public void setSelectedTemplate(TemplateExtender template) {
        this.mSelectedTemplate = template;
    }

    public TemplateExtender getSelectedTemplate() {
        return this.mSelectedTemplate;
    }

    public static void addListener(ITemplateWizardListener listener) {
        mListener.add(listener);
    }

    public static void removeListener(ITemplateWizardListener listener) {
        mListener.remove(listener);
    }

    public static ITemplateWizardListener[] getListener() {
        ITemplateWizardListener[] listener = mListener.toArray(new ITemplateWizardListener[0]);
        return listener;
    }
}

