/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.template.extensionmanagement;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.template.ITemplateWizard;
import com.sap.ide.tools.core.template.TemplatePlugin;
import com.sap.ide.tools.core.template.service.ITemplateApplicable;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.tools.core.template.service.NatureEnum;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class TemplateExtender {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_APPLICABLE_CLASS = "applicableClass";
    private static final String ATTRIBUTE_WIZARD_CLASS = "wizardClass";
    private static final String ATTRIBUTE_DATA_CLASS = "dataClass";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SINGLETON = "singleton";
    private static final String ATTRIBUTE_NATURE = "nature";
    private static final String ATTRIBUTE_ICONLARGE = "iconLarge";
    private IConfigurationElement mConfigurationElement = null;
    private ITemplateApplicable mTemplateApplicable = null;
    private ITemplateWizard mTemplateWizard = null;
    private ITemplateData mTemplateData = null;
    private DevelopmentObject mContainingObject = null;
    private String mType = null;

    public TemplateExtender(IConfigurationElement element, DevelopmentObject containingObject) {
        this.mConfigurationElement = element;
        this.mTemplateApplicable = this.getTemplateApplicableClass(this.mConfigurationElement);
        this.mTemplateWizard = this.getTemplateWizardClass(this.mConfigurationElement);
        this.mTemplateData = this.getTemplateDataClass(this.mConfigurationElement);
        if (this.mTemplateWizard != null) {
            this.mTemplateWizard.setData(this.mTemplateData);
        }
        this.mContainingObject = containingObject;
        this.mType = this.getType();
    }

    public boolean isValid() {
        return this.mTemplateApplicable != null;
    }

    public DevelopmentObject getContainingObject() {
        return this.mContainingObject;
    }

    private ITemplateApplicable getTemplateApplicableClass(IConfigurationElement element) {
        ITemplateApplicable templateApplicable = null;
        Object object = null;
        try {
            object = element.createExecutableExtension(ATTRIBUTE_APPLICABLE_CLASS);
        }
        catch (CoreException e) {
            TemplatePlugin.internalError(this.getClass(), "getApplicableClass(IConfigurationElement)", e.getMessage(), e, false);
        }
        if (object instanceof ITemplateApplicable) {
            templateApplicable = (ITemplateApplicable)object;
        }
        return templateApplicable;
    }

    private ITemplateWizard getTemplateWizardClass(IConfigurationElement element) {
        ITemplateWizard templateWizard = null;
        Object object = null;
        try {
            object = element.createExecutableExtension(ATTRIBUTE_WIZARD_CLASS);
        }
        catch (CoreException e) {
            TemplatePlugin.internalError(this.getClass(), "getTemplateWizardClass(IConfigurationElement)", e.getMessage(), e, false);
        }
        if (object instanceof ITemplateWizard) {
            templateWizard = (ITemplateWizard)object;
        }
        return templateWizard;
    }

    private ITemplateData getTemplateDataClass(IConfigurationElement element) {
        ITemplateData templateData = null;
        Object object = null;
        try {
            object = element.createExecutableExtension(ATTRIBUTE_DATA_CLASS);
        }
        catch (CoreException e) {
            TemplatePlugin.internalError(this.getClass(), "getTemplateDataClass(IConfigurationElement)", e.getMessage(), e, false);
        }
        if (object instanceof ITemplateData) {
            templateData = (ITemplateData)object;
        }
        return templateData;
    }

    public String getName() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_NAME);
    }

    public String getId() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_ID);
    }

    public String getType() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_TYPE);
    }

    public boolean getSingleton() {
        String value = this.mConfigurationElement.getAttribute(ATTRIBUTE_SINGLETON);
        return value.equals("true");
    }

    public NatureEnum getNature() {
        String value = this.mConfigurationElement.getAttribute(ATTRIBUTE_NATURE);
        if (value.equals("Generation")) {
            return NatureEnum.GENERATION;
        }
        return NatureEnum.METADATA;
    }

    public ITemplateWizard getWizardClass() {
        return this.mTemplateWizard;
    }

    public ITemplateData getDataClass() {
        return this.mTemplateData;
    }

    public ITemplateApplicable getApplicableClass() {
        return this.mTemplateApplicable;
    }

    public String getPluginPath() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_ICONLARGE);
    }
}

