/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom3.DOMImplementationSource;
import org.w3c.dom.DOMImplementation;

public class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final Vector sources = new Vector();

    private static void reInitialize() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        StringTokenizer stringTokenizer;
        String string;
        int n = 0;
        while (n < sources.size()) {
            string = ((Class)sources.elementAt(n)).getName();
            try {
                stringTokenizer = NewInstance.getClass(string).newInstance();
                sources.setElementAt(stringTokenizer, n);
                ++n;
            }
            catch (Exception exception) {
                sources.removeElementAt(n);
            }
        }
        string = System.getProperty(PROPERTY);
        if (string == null) {
            return;
        }
        stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            Object t = NewInstance.getClass(stringTokenizer.nextToken()).newInstance();
            sources.addElement(t);
        }
    }

    public static DOMImplementation getDOMImplementation(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry.reInitialize();
        int n = sources.size();
        int n2 = 0;
        while (n2 < n) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)sources.elementAt(n2);
            DOMImplementation dOMImplementation = dOMImplementationSource.getDOMImplementation(string);
            if (dOMImplementation != null) {
                return dOMImplementation;
            }
            ++n2;
        }
        return null;
    }

    public static void addSource(DOMImplementationSource dOMImplementationSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry.reInitialize();
        sources.addElement(dOMImplementationSource);
        StringBuffer stringBuffer = new StringBuffer(System.getProperty(PROPERTY));
        stringBuffer.append(" " + dOMImplementationSource.getClass().getName());
        System.setProperty(PROPERTY, stringBuffer.toString());
    }

    private static class NewInstance {
        static /* synthetic */ Class class$java$lang$Thread;
        static /* synthetic */ Class class$org$apache$xerces$dom3$DOMImplementationRegistry;

        private NewInstance() {
        }

        static Class getClass(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            Method method = null;
            ClassLoader classLoader = null;
            try {
                method = (class$java$lang$Thread == null ? (class$java$lang$Thread = NewInstance.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                classLoader = (class$org$apache$xerces$dom3$DOMImplementationRegistry == null ? (class$org$apache$xerces$dom3$DOMImplementationRegistry = NewInstance.class$("org.apache.xerces.dom3.DOMImplementationRegistry")) : class$org$apache$xerces$dom3$DOMImplementationRegistry).getClassLoader();
            }
            if (classLoader == null) {
                try {
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnknownError(illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new UnknownError(invocationTargetException.getMessage());
                }
            }
            if (classLoader == null) {
                return Class.forName(string);
            }
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Class.forName(string);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

