/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.locking;

import com.sap.engine.frame.core.locking.DescribedFile;
import com.sap.engine.frame.core.locking.DescribedFileContent;
import com.sap.engine.frame.core.locking.SAPLockingIOException;
import com.sap.engine.frame.core.locking.SAPLockingIllegalArgumentException;
import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.exception.standard.SAPNumberFormatException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Properties;

public final class Util {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public boolean equalsWithNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public Object[] extendArray(int before, Object[] source, int after) {
        Object[] result = new Object[before + source.length + after];
        System.arraycopy(source, 0, result, before, source.length);
        return result;
    }

    public String[] extendArray(int before, String[] source, int after) {
        String[] result = new String[before + source.length + after];
        System.arraycopy(source, 0, result, before, source.length);
        return result;
    }

    public long[] extendArray(int before, long[] source, int after) {
        long[] result = new long[before + source.length + after];
        System.arraycopy(source, 0, result, before, source.length);
        return result;
    }

    public boolean isStringReadable(String str) {
        int i = 0;
        while (i < str.length()) {
            char next = str.charAt(i);
            if (next != '\n' && next != '\r' && next != '\t' && Character.isISOControl(next)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String convertByteArrayToString(byte[] source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length + source.length);
        int i = 0;
        while (i < source.length) {
            String next;
            int adjusted = source[i];
            if (adjusted < 0) {
                adjusted = 256 + adjusted;
            }
            if ((next = Integer.toHexString(adjusted)).length() == 1) {
                result.append('0').append(next);
            } else {
                result.append(next);
            }
            ++i;
        }
        return result.toString();
    }

    public byte[] convertStringToByteArray(String source) {
        if (source == null) {
            return null;
        }
        byte[] result = new byte[(source.length() + 1) / 2];
        int i = 0;
        while (i < result.length) {
            int start = i * 2;
            int end = start + 2;
            if (end > source.length()) {
                --end;
            }
            String next = source.substring(start, end);
            try {
                int parsed = Integer.parseInt(next, 16);
                if (parsed < 0) {
                    parsed = 256 + parsed;
                }
                result[i] = (byte)parsed;
            }
            catch (NumberFormatException e) {
                throw new SAPNumberFormatException("com.sap.exception.standard_0014", new Object[]{next, new Integer(start)});
            }
            ++i;
        }
        return result;
    }

    public String rightTrim(String s) {
        if (s == null) {
            return s;
        }
        int newLength = s.length();
        while (0 < newLength && s.charAt(newLength - 1) <= ' ') {
            --newLength;
        }
        return newLength != s.length() ? s.substring(0, newLength) : s;
    }

    public String adjustStringLengthRight(String start, int length, char fillChar) {
        int sl;
        if (start == null) {
            start = "";
        }
        if ((sl = start.length()) == length) {
            return start;
        }
        if (sl > length) {
            return start.substring(0, length);
        }
        StringBuffer result = new StringBuffer(length);
        result.append(start);
        int i = sl;
        while (i < length) {
            result.append(fillChar);
            ++i;
        }
        return result.toString();
    }

    public String adjustStringLengthLeft(String end, int length, char fillChar) {
        int sl;
        if (end == null) {
            end = "";
        }
        if ((sl = end.length()) == length) {
            return end;
        }
        if (sl > length) {
            return end.substring(0, length);
        }
        StringBuffer result = new StringBuffer(length);
        int i = sl;
        while (i < length) {
            result.append(fillChar);
            ++i;
        }
        result.append(end);
        return result.toString();
    }

    public int compareStringsUsingWildcards(String s1, String s2, char wildcard) {
        if (s1 == null && s2 == null) {
            return 2;
        }
        if (s1 == null || s2 == null) {
            return 0;
        }
        int length = s1.length();
        if (length != s2.length()) {
            return 0;
        }
        int result = 2;
        int i = 0;
        while (i < length) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                if (c1 == wildcard || c2 == wildcard) {
                    result = 1;
                } else {
                    return 0;
                }
            }
            ++i;
        }
        return result;
    }

    public int compareStringsUsingWildcards(String stringWithoutWildcards, String stringWithWildcards, char wildcardSingle, char wildcardMulti, char ignoreCharAtEnd) {
        if (stringWithoutWildcards == null && stringWithWildcards == null) {
            return 2;
        }
        if (stringWithoutWildcards == null || stringWithWildcards == null) {
            return 0;
        }
        boolean beginsWithMulti = false;
        boolean endsWithMulti = false;
        if (stringWithWildcards.charAt(0) == wildcardMulti) {
            if (stringWithWildcards.length() == 1) {
                return 1;
            }
            beginsWithMulti = true;
            stringWithWildcards = stringWithWildcards.substring(1);
        }
        if (stringWithWildcards.indexOf(wildcardMulti) > 0) {
            endsWithMulti = true;
            stringWithWildcards = stringWithWildcards.substring(0, stringWithWildcards.indexOf(wildcardMulti));
        }
        if (stringWithWildcards.length() > stringWithoutWildcards.length()) {
            return 0;
        }
        int pos = 0;
        while (pos <= stringWithoutWildcards.length() - stringWithWildcards.length()) {
            if (!beginsWithMulti && pos > 0) {
                return 0;
            }
            int result = 2;
            int i = 0;
            while (i < stringWithWildcards.length()) {
                char c2;
                char c1 = stringWithoutWildcards.charAt(i + pos);
                if (c1 != (c2 = stringWithWildcards.charAt(i))) {
                    if (c2 == wildcardSingle) {
                        result = 1;
                    } else {
                        result = 0;
                        break;
                    }
                }
                ++i;
            }
            if (!endsWithMulti && stringWithWildcards.length() + pos != stringWithoutWildcards.length()) {
                int i2 = pos + stringWithWildcards.length();
                while (i2 < stringWithoutWildcards.length()) {
                    if (stringWithoutWildcards.charAt(i2) != ignoreCharAtEnd) {
                        result = 0;
                        break;
                    }
                    ++i2;
                }
            }
            if (result != 0) {
                return result;
            }
            ++pos;
        }
        return 0;
    }

    public String replaceChars(String text, char before, String after) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(text.length() + 128);
        int i = 0;
        while (i < text.length()) {
            char next = text.charAt(i);
            if (next == before) {
                if (after != null) {
                    buffer.append(after);
                }
            } else {
                buffer.append(next);
            }
            ++i;
        }
        return buffer.toString();
    }

    public Boolean getBooleanProperty(Properties properties, String name, boolean allowNull) throws NullPointerException {
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new SAPNumberFormatException("com.sap.exception.standard_0016", new Object[]{string, name});
    }

    public Integer getIntegerProperty(Properties properties, String name, int min, int max, boolean allowNull) throws NumberFormatException, NullPointerException {
        Integer result;
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        try {
            int parsed = Integer.parseInt(string);
            result = new Integer(parsed);
        }
        catch (NumberFormatException e) {
            throw new SAPNumberFormatException("com.sap.exception.standard_0019", new Object[]{string, name});
        }
        if (result < min) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0009", new Object[]{name, new Integer(min), result});
        }
        if (result > max) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0010", new Object[]{name, new Integer(max), result});
        }
        return result;
    }

    public Integer getIntegerProperty(Properties properties, String name, boolean allowNull) throws NumberFormatException, NullPointerException {
        return this.getIntegerProperty(properties, name, Integer.MIN_VALUE, Integer.MAX_VALUE, allowNull);
    }

    public String getStringProperty(Properties properties, String name, int maxlength, boolean allowNull) throws NumberFormatException, NullPointerException {
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        if (maxlength >= 0 && string.length() > maxlength) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0026", new Object[]{name, new Integer(maxlength), new Integer(string.length()), string});
        }
        return string;
    }

    public String getStringProperty(Properties properties, String name, boolean allowNull) throws NumberFormatException, NullPointerException {
        return this.getStringProperty(properties, name, -1, allowNull);
    }

    public String getStackTrace(Throwable t) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter wrapper = new PrintWriter(writer);
            t.printStackTrace(wrapper);
            return writer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void checkMode(char mode) throws IllegalArgumentException {
        if (mode != 'X' && mode != 'E' && mode != 'S' && mode != 'O' && mode != 'R') {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0007", new Object[]{"mode", new Character(mode), "LockingConstants.MODE_EXCLUSIVE_NONCUMULATIVE, LockingConstants.MODE_EXCLUSIVE_CUMULATIVE, LockingConstants.MODE_SHARED, LockingConstants.MODE_OPTIMISTIC, LockingConstants.MODE_OPTIMISTIC_TO_EXCLUSIVE"});
        }
    }

    public void checkParameter(String parameterName, String parameter, int maxLength, boolean allowNull) throws IllegalArgumentException {
        if (parameter == null) {
            if (allowNull) {
                return;
            }
            throw new SAPLockingIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{parameterName});
        }
        if (parameter.length() > maxLength) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0025", new Object[]{parameterName, new Integer(parameter.length()), new Integer(maxLength), parameter});
        }
    }

    public void checkParameterTruncation(String parameterName, String parameter, int maxLength, boolean allowTruncation) throws IllegalArgumentException {
        if (parameter == null) {
            return;
        }
        if (parameter.length() > maxLength && !allowTruncation) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0025", new Object[]{parameterName, new Integer(parameter.length()), new Integer(maxLength), parameter});
        }
    }

    public char getMode(String mode) throws IllegalArgumentException {
        if (mode == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"mode"});
        }
        if (mode.length() < 1) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0004", new Object[]{"mode", new Integer(mode.length()), new Integer(1), mode});
        }
        if (mode.length() > 1) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0025", new Object[]{"mode", new Integer(mode.length()), new Integer(1), mode});
        }
        char first = Character.toUpperCase(mode.charAt(0));
        if (first == 'S' || first == 'E' || first == 'X') {
            return first;
        }
        throw new SAPIllegalArgumentException("com.sap.exception.standard_0007", new Object[]{"mode", new Character(first), "LockingConstants.MODE_EXCLUSIVE_NONCUMULATIVE, LockingConstants.MODE_EXCLUSIVE_CUMULATIVE, LockingConstants.MODE_SHARED"});
    }

    public void appendWithArrayHandling(StringBuffer s, Object o) {
        if (o == null) {
            s.append(o);
        } else if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof char[]) {
            char[] array = (char[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof int[]) {
            int[] array = (int[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof long[]) {
            long[] array = (long[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof boolean[]) {
            boolean[] array = (boolean[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else {
            s.append(o);
        }
    }

    public DescribedFileContent getDescribedFileContent(DescribedFile file, int readNumberOfBytes, int readFromPosition) throws IOException {
        int length;
        File f = file.getFile();
        if (!f.exists()) {
            return new DescribedFileContent(1);
        }
        if (!f.isFile()) {
            return new DescribedFileContent(2);
        }
        if (!f.canRead()) {
            return new DescribedFileContent(3);
        }
        RandomAccessFile reader = new RandomAccessFile(f, "r");
        long realLength = reader.length();
        if (realLength > Integer.MAX_VALUE) {
            throw new SAPLockingIOException("kernel_1080", new Object[]{f, new Long(realLength), new Integer(Integer.MAX_VALUE)});
        }
        int position = readFromPosition < 0 ? length + readFromPosition - 1 : readFromPosition;
        if (position > (length = (int)realLength)) {
            position = length - 1;
        } else if (position < 0) {
            position = 0;
        }
        int bytesToRead = readNumberOfBytes < 0 ? length : readNumberOfBytes;
        if (position + bytesToRead >= length) {
            bytesToRead = length - position;
        }
        byte[] content = new byte[bytesToRead];
        reader.seek(position);
        reader.read(content, 0, bytesToRead);
        DescribedFileContent result = new DescribedFileContent(content, length);
        return result;
    }
}

