/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.locking;

import com.sap.engine.frame.core.locking.Util;
import java.io.Serializable;

public class TimeStatisticsEntry
implements Serializable {
    private static final Util UTIL = new Util();
    private String _description;
    private long _counts;
    private long _cumulatedDeltas;
    private long _minDelta;
    private long _maxDelta;

    public TimeStatisticsEntry(String description) {
        this._description = description;
        this._minDelta = Integer.MAX_VALUE;
        this._maxDelta = Integer.MIN_VALUE;
    }

    public void addDeltaTime(long deltaTime) {
        ++this._counts;
        this._cumulatedDeltas += deltaTime;
        this._minDelta = Math.min(this._minDelta, deltaTime);
        this._maxDelta = Math.max(this._maxDelta, deltaTime);
    }

    public String getDescription() {
        return this._description;
    }

    public long getCounts() {
        return this._counts;
    }

    public long getCumulatedDeltas() {
        return this._cumulatedDeltas;
    }

    public long getAverageDelta() {
        return this._cumulatedDeltas / this._counts;
    }

    public long getMinDelta() {
        return this._minDelta;
    }

    public long getMaxDelta() {
        return this._maxDelta;
    }

    public String toString() {
        return this._description + ": average time = " + this.getAverageDelta() + ", number of counts = " + this.getCounts();
    }
}

