/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.locking;

import com.sap.engine.frame.core.locking.TimeStatisticsEntry;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.lib.time.SystemTime;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Hashtable;

public class TimeStatistics {
    private static final String[] MONITORING_TABLE_HEADER = new String[]{"description", "average (us)", "min (us)", "max (us)", "count"};
    private static final Util UTIL = new Util();
    private int _level;
    private Hashtable _indexForEntry;
    private TimeStatisticsEntry[] _allEntries;

    public TimeStatistics() {
        this.resetTimeStatistics();
    }

    public Throwable getInitializationFailure() {
        return SystemTime.getInitializationFailure();
    }

    public void setTimeStatisticsLevel(int level) {
        this._level = level;
    }

    public synchronized void resetTimeStatistics() {
        this._allEntries = new TimeStatisticsEntry[0];
        this._indexForEntry = new Hashtable();
    }

    public int getTimeStatisticsLevel() {
        return this._level;
    }

    public long startMeasurement(int level) {
        if (this._level < level) {
            return -1L;
        }
        return SystemTime.currentTimeStamp();
    }

    public long endMeasurement(long startTime, Location location, String sublocation, String description) {
        if (startTime == -1L) {
            return -1L;
        }
        long endTime = SystemTime.currentTimeStamp();
        long deltaTime = SystemTime.calculateTimeStampDeltaInMicros((long)startTime, (long)endTime);
        this.writeTrace(deltaTime, location, sublocation, description);
        this.cumulateTimes(deltaTime, description);
        return deltaTime;
    }

    public void addTimeStatisticsEntry(long deltaTime, Location location, String sublocation, String description) {
        this.writeTrace(deltaTime, location, sublocation, description);
        this.cumulateTimes(deltaTime, description);
    }

    public TimeStatisticsEntry[] getTimeStatisticsEntries() {
        return this._allEntries;
    }

    private void writeTrace(long deltaTime, Location location, String sublocation, String description) {
        if (location != null && location.bePath()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Time: ");
            sb.append(deltaTime);
            sb.append(" us ");
            sb.append(description);
            location.pathT(sublocation, sb.toString());
        }
    }

    private synchronized void cumulateTimes(long deltaTime, String description) {
        int index;
        Object indexObject = this._indexForEntry.get(description);
        if (indexObject != null) {
            index = (Integer)indexObject;
        } else {
            TimeStatisticsEntry[] newAllEntries = new TimeStatisticsEntry[this._allEntries.length + 1];
            System.arraycopy(this._allEntries, 0, newAllEntries, 0, this._allEntries.length);
            this._allEntries = newAllEntries;
            index = this._allEntries.length - 1;
            this._allEntries[index] = new TimeStatisticsEntry(description);
            this._indexForEntry.put(description, new Integer(index));
        }
        this._allEntries[index].addDeltaTime(deltaTime);
    }

    public String[] getMonitoringTableHeader() {
        return MONITORING_TABLE_HEADER;
    }

    public synchronized Serializable[][] getMonitoringTableData() {
        Serializable[][] result = new Serializable[this._allEntries.length][5];
        int i = 0;
        while (i < this._allEntries.length) {
            TimeStatisticsEntry next = this._allEntries[i];
            result[i][0] = next.getDescription();
            result[i][1] = new Long(next.getAverageDelta());
            result[i][2] = new Long(next.getMinDelta());
            result[i][3] = new Long(next.getMaxDelta());
            result[i][4] = new Long(next.getCounts());
            ++i;
        }
        return result;
    }
}

