/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.locking;

import com.sap.engine.frame.core.locking.Util;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.Serializable;

public class LockEntry
implements Serializable {
    private static final Util UTIL = new Util();
    private String _owner;
    private String _name;
    private String _argument;
    private int _count;
    private char _mode;
    private String _user;

    public LockEntry(String user, String owner, String name, String argument, int count, char mode) throws IllegalArgumentException {
        try {
            UTIL.checkParameter("user", user, 12, false);
            this._user = user;
        }
        catch (SAPIllegalArgumentException siae) {
            if (user != null) {
                this._user = user.substring(0, 12);
            }
            throw siae;
        }
        UTIL.checkParameter("owner", owner, 58, false);
        UTIL.checkParameter("name", name, 30, false);
        UTIL.checkParameter("argument", argument, 150, false);
        UTIL.checkMode(mode);
        this._owner = owner;
        this._name = name;
        this._argument = argument;
        this._count = count;
        this._mode = mode;
    }

    public String getUser() {
        return this._user;
    }

    public String getName() {
        return this._name;
    }

    public char getMode() {
        return this._mode;
    }

    public String getArgument() {
        return this._argument;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getCount() {
        return this._count;
    }

    public String toString() {
        return "LockEntry[user= " + this.getUser() + ", owner=" + this.getOwner() + ", name=" + this.getName() + ", argument=" + this.getArgument() + ", mode=" + this.getMode() + ", count=" + this.getCount() + "]";
    }
}

