/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.gui;

import com.sap.engine.frame.core.load.gui.ItemInfo;
import java.io.Serializable;

public final class ComponentInfo
implements Serializable {
    public static final byte NOT_KNOWN = 0;
    public static final byte COMPONENT_INTERFACE = 1;
    public static final byte COMPONENT_LIBRARY = 2;
    public static final byte COMPONENT_SERVICE = 3;
    public static final byte COMPONENT_APPLICATION = 4;
    public static final byte COMPONENT_COMMON = 5;
    public static final byte RESOURCE_JAR = 10;
    public static final byte RESOURCE_OTHER = 11;
    private ItemInfo mineInfo;
    private boolean initialized;
    private String parentName;
    private String[] references;
    private String[] referees;
    private String[] resources;
    private ItemInfo[] parsedReferences;
    private ItemInfo[] parsedReferees;
    private ItemInfo[] parsedResources;

    public ComponentInfo(String name, String parent, String[] references, String[] referees, String[] resources, boolean initialized) {
        this.mineInfo = ItemInfo.parseComponent(name);
        this.parentName = parent;
        this.references = references;
        this.referees = referees;
        this.resources = resources;
        this.initialized = initialized;
    }

    public String getFullName() {
        return this.mineInfo.getFullName();
    }

    public String getShortName() {
        return this.mineInfo.getShortName();
    }

    public byte getComponentType() {
        return this.mineInfo.getType();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getParent() {
        return this.parentName;
    }

    public String[] getReferences() {
        return this.references;
    }

    public String[] getReferees() {
        return this.referees;
    }

    public String[] getResources() {
        return this.resources;
    }

    public ItemInfo[] getParsedReferences() {
        if (this.parsedReferences == null) {
            this.parsedReferences = ItemInfo.parseComponents(this.references);
        }
        return this.parsedReferences;
    }

    public ItemInfo[] getParsedReferees() {
        if (this.parsedReferees == null) {
            this.parsedReferees = ItemInfo.parseComponents(this.referees);
        }
        return this.parsedReferees;
    }

    public ItemInfo[] getParsedResources() {
        if (this.parsedResources == null) {
            this.parsedResources = ItemInfo.parseResources(this.resources);
        }
        return this.parsedResources;
    }
}

