/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load;

import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ClassLoadingLog {
    public static final byte MIN_VALUE = 0;
    public static final byte MAX_VALUE = 8;
    public static final byte EMERGENCY = 8;
    public static final byte ALERT = 7;
    public static final byte CRITICAL = 6;
    public static final byte ERROR = 5;
    public static final byte WARNING = 4;
    public static final byte NOTICE = 3;
    public static final byte INFO = 2;
    public static final byte TRACE = 1;
    public static final byte DEBUG = 0;

    public static void logThrowable(Location location, byte type, String subLocation, Throwable cause) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        cause.printStackTrace(out);
        ClassLoadingLog.logMessage(location, type, subLocation, buffer.toString());
    }

    public static void logThrowable(Location location, byte type, String subLocation, Throwable cause, Object[] args) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        cause.printStackTrace(out);
        ClassLoadingLog.logMessage(location, type, subLocation, buffer.toString(), args);
    }

    public static void logMessage(Location location, byte type, String subLocation, String message) {
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                location.fatalT(subLocation, message);
                break;
            }
            case 5: {
                location.errorT(subLocation, message);
                break;
            }
            case 4: {
                location.warningT(subLocation, message);
                break;
            }
            case 2: 
            case 3: {
                location.pathT(subLocation, message);
                break;
            }
            case 0: 
            case 1: {
                location.debugT(subLocation, message);
            }
        }
    }

    public static void logMessage(Location location, byte type, String subLocation, String message, Object[] args) {
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                location.fatalT(subLocation, message, args);
                break;
            }
            case 5: {
                location.errorT(subLocation, message, args);
                break;
            }
            case 4: {
                location.warningT(subLocation, message, args);
                break;
            }
            case 2: 
            case 3: {
                location.pathT(subLocation, message, args);
                break;
            }
            case 0: 
            case 1: {
                location.debugT(subLocation, message, args);
            }
        }
    }
}

