/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.cluster.balance;

public class Destination {
    protected int[] clusterIds;

    public Destination() {
        this.clusterIds = new int[0];
    }

    public Destination(int clusterId) {
        this.clusterIds = new int[1];
        this.clusterIds[0] = clusterId;
    }

    public Destination(int[] clusterIds) {
        this.clusterIds = new int[clusterIds.length];
        System.arraycopy(clusterIds, 0, this.clusterIds, 0, clusterIds.length);
    }

    public synchronized void removeElement(int clusterId) {
        int i = 0;
        while (i < this.clusterIds.length) {
            if (this.clusterIds[i] == clusterId) {
                int[] tmp = new int[this.clusterIds.length - 1];
                System.arraycopy(this.clusterIds, 0, tmp, 0, i);
                System.arraycopy(this.clusterIds, i + 1, tmp, i, this.clusterIds.length - i - 1);
                this.clusterIds = tmp;
                break;
            }
            ++i;
        }
    }

    public synchronized void addElement(int clusterId) {
        int i = 0;
        while (i < this.clusterIds.length) {
            if (this.clusterIds[i] == clusterId) {
                return;
            }
            ++i;
        }
        int[] tmp = new int[this.clusterIds.length + 1];
        System.arraycopy(this.clusterIds, 0, tmp, 0, this.clusterIds.length);
        tmp[tmp.length - 1] = clusterId;
        this.clusterIds = tmp;
    }

    public synchronized int[] getClusterIds() {
        int[] result = new int[this.clusterIds.length];
        System.arraycopy(this.clusterIds, 0, result, 0, this.clusterIds.length);
        return result;
    }

    public synchronized boolean hasClusterId(int clusterId) {
        boolean result = false;
        int i = 0;
        while (i < this.clusterIds.length) {
            if (this.clusterIds[i] == clusterId) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public synchronized boolean equals(Destination destination) {
        int[] external = destination.getClusterIds();
        boolean result = true;
        int i = 0;
        while (i < external.length) {
            if (!this.hasClusterId(external[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }
}

