/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskListMessages;

class RemoveTaskAction
extends TaskAction {
    public RemoveTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.remove_task_action_context");
    }

    public void run() {
        TaskList taskList = this.getTaskList();
        TableViewer viewer = taskList.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        taskList.cancelEditing();
        Table table = viewer.getTable();
        int focusIndex = table.getSelectionIndex();
        try {
            List list = selection.toList();
            IMarker[] markers = new IMarker[list.size()];
            list.toArray(markers);
            taskList.getWorkspace().deleteMarkers(markers);
            int count = table.getItemCount();
            if (focusIndex < count) {
                table.setSelection(focusIndex);
            } else if (count != 0) {
                table.setSelection(count - 1);
            }
            viewer.setSelection(viewer.getSelection(), true);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.getString("RemoveTask.errorMessage"), null, (IStatus)e.getStatus());
        }
    }
}

