/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.util.ArrayList;
import org.eclipse.help.IContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.ui.help.IContextComputer;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetViewer;

class PropertySheetPageContextComputer
implements IContextComputer {
    private PropertySheetViewer viewer;
    private ArrayList contextList;
    private Object context;

    public PropertySheetPageContextComputer(PropertySheetViewer propertySheetViewer, Object helpContext) {
        Assert.isTrue((helpContext instanceof String || helpContext instanceof IContext ? 1 : 0) != 0);
        this.viewer = propertySheetViewer;
        this.context = helpContext;
    }

    private void addContexts(Object object, HelpEvent event) {
        Assert.isTrue((object instanceof Object[] || object instanceof IContextComputer || object instanceof String ? 1 : 0) != 0);
        if (object instanceof String) {
            this.contextList.add(object);
            return;
        }
        Object[] contexts = object instanceof IContextComputer ? ((IContextComputer)object).getLocalContexts(event) : (Object[])object;
        int i = 0;
        while (i < contexts.length) {
            this.contextList.add(contexts[i]);
            ++i;
        }
    }

    public Object[] computeContexts(HelpEvent event) {
        IPropertySheetEntry entry;
        Object helpContextIds;
        this.contextList = new ArrayList();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && (helpContextIds = (entry = (IPropertySheetEntry)selection.getFirstElement()).getHelpContextIds()) != null) {
            this.addContexts(helpContextIds, event);
        }
        this.contextList.add(this.context);
        return this.contextList.toArray();
    }

    public Object[] getLocalContexts(HelpEvent event) {
        return new Object[]{this.context};
    }
}

