/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.framelist.Frame;

public class TreeFrame
extends Frame {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_FRAME_INPUT = "frameInput";
    private AbstractTreeViewer viewer;
    private Object input;
    private ISelection selection;
    private Object[] expandedElements;
    static /* synthetic */ Class class$0;

    public TreeFrame(AbstractTreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeFrame(AbstractTreeViewer viewer, Object input) {
        this(viewer);
        this.setInput(input);
        ILabelProvider provider = (ILabelProvider)viewer.getLabelProvider();
        String name = provider.getText(input);
        this.setName(name);
        this.setToolTipText(name);
    }

    public Object[] getExpandedElements() {
        return this.expandedElements;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    private List restoreElements(IMemento memento) {
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(elementMem.length);
        int i = 0;
        while (i < elementMem.length) {
            IElementFactory factory;
            String factoryID = elementMem[i].getString("factoryID");
            if (factoryID != null && (factory = WorkbenchPlugin.getDefault().getElementFactory(factoryID)) != null) {
                elements.add(factory.createElement(elementMem[i]));
            }
            ++i;
        }
        return elements;
    }

    public void restoreState(IMemento memento) {
        IMemento expandedMem;
        IElementFactory factory;
        IMemento childMem = memento.getChild(TAG_FRAME_INPUT);
        if (childMem == null) {
            return;
        }
        String factoryID = childMem.getString("factoryID");
        IAdaptable frameInput = null;
        if (factoryID != null && (factory = WorkbenchPlugin.getDefault().getElementFactory(factoryID)) != null) {
            frameInput = factory.createElement(childMem);
        }
        if (frameInput != null) {
            this.input = frameInput;
        }
        if ((expandedMem = memento.getChild(TAG_EXPANDED)) != null) {
            List elements = this.restoreElements(expandedMem);
            this.expandedElements = elements.toArray(new Object[elements.size()]);
        } else {
            this.expandedElements = new Object[0];
        }
        IMemento selectionMem = memento.getChild(TAG_SELECTION);
        if (selectionMem != null) {
            List elements = this.restoreElements(selectionMem);
            this.selection = new StructuredSelection(elements);
        } else {
            this.selection = StructuredSelection.EMPTY;
        }
    }

    private void saveElements(Object[] elements, IMemento memento) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IAdaptable) {
                IPersistableElement persistable;
                IAdaptable iAdaptable = (IAdaptable)elements[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((persistable = (IPersistableElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IMemento elementMem = memento.createChild(TAG_ELEMENT);
                    elementMem.putString("factoryID", persistable.getFactoryId());
                    persistable.saveState(elementMem);
                }
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        IPersistableElement persistable;
        if (!(this.input instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)this.input;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IPersistableElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((persistable = (IPersistableElement)iAdaptable.getAdapter((Class)clazz)) != null) {
            Object[] elements;
            IMemento frameMemento = memento.createChild(TAG_FRAME_INPUT);
            frameMemento.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(frameMemento);
            if (this.expandedElements.length > 0) {
                IMemento expandedMem = memento.createChild(TAG_EXPANDED);
                this.saveElements(this.expandedElements, expandedMem);
            }
            if (this.selection instanceof IStructuredSelection && (elements = ((IStructuredSelection)this.selection).toArray()).length > 0) {
                IMemento selectionMem = memento.createChild(TAG_SELECTION);
                this.saveElements(elements, selectionMem);
            }
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setExpandedElements(Object[] expandedElements) {
        this.expandedElements = expandedElements;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

