/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.FrameListMessages;

public class ForwardAction
extends FrameAction {
    public ForwardAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.getString("Forward.text"));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_HOVER"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.forward_action_context");
        this.update();
    }

    private Frame getNextFrame() {
        FrameList list = this.getFrameList();
        return list.getFrame(list.getCurrentIndex() + 1);
    }

    private String getToolTipText(Frame nextFrame) {
        String text;
        if (nextFrame != null && (text = nextFrame.getToolTipText()) != null && text.length() > 0) {
            return FrameListMessages.format("Forward.toolTipOneArg", new Object[]{text});
        }
        return FrameListMessages.getString("Forward.toolTip");
    }

    public void run() {
        this.getFrameList().forward();
    }

    public void update() {
        super.update();
        Frame nextFrame = this.getNextFrame();
        this.setEnabled(nextFrame != null);
        this.setToolTipText(this.getToolTipText(nextFrame));
    }
}

