/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.workarounds;

import com.tssap.j2ee.internal.core.ejb.util.HashBag;
import com.tssap.j2ee.internal.core.ejb.workarounds.IProjectDependencyWorkaroundListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ProjectDependencyListener
implements IResourceChangeListener {
    private static ProjectDependencyListener mySelf;
    private HashBag myListeners = new HashBag();
    private static final String CLASSPATH_PROJECT_RELATIVE_PATH = ".classpath";
    private HashBag myProjectDependencyTree;

    private ProjectDependencyListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        Collection affectedProjects = this.collectProjectsWithChangedClassPath(event.getDelta());
        Iterator it = affectedProjects.iterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            this.fireWorkaround(next);
        }
    }

    private Collection collectProjectsWithChangedClassPath(IResourceDelta delta) {
        ClassPathChangeFinder finder = new ClassPathChangeFinder(this.myProjectDependencyTree != null);
        try {
            delta.accept((IResourceDeltaVisitor)finder);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        HashSet result = new HashSet();
        if (finder.projectDependencyTreeNeedsRefresh()) {
            this.updateProjectDependencyTree();
        }
        Iterator it = finder.getCollectedProjects().iterator();
        while (it.hasNext()) {
            this.addWithDependants(result, (IProject)it.next());
        }
        return result;
    }

    private void addWithDependants(Collection result, IProject project) {
        if (result.contains(project)) {
            return;
        }
        result.add(project);
        Iterator it = this.myProjectDependencyTree.get(project).iterator();
        while (it.hasNext()) {
            this.addWithDependants(result, (IProject)it.next());
        }
    }

    private void updateProjectDependencyTree() {
        this.myProjectDependencyTree = new HashBag();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject next = projects[i];
            if (next.isAccessible()) {
                try {
                    IProject[] referenced = next.getDescription().getReferencedProjects();
                    int j = 0;
                    while (j < referenced.length) {
                        this.myProjectDependencyTree.add(referenced[j], next);
                        ++j;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static ProjectDependencyListener getInstance() {
        if (mySelf == null) {
            mySelf = new ProjectDependencyListener();
        }
        return mySelf;
    }

    public void addWorkaroundListener(IProject project, IProjectDependencyWorkaroundListener listener) {
        HashBag hashBag = this.myListeners;
        synchronized (hashBag) {
            this.myListeners.add(project, listener);
        }
    }

    public void removeWorkaroundListener(IProject project, IProjectDependencyWorkaroundListener listener) {
        HashBag hashBag = this.myListeners;
        synchronized (hashBag) {
            this.myListeners.remove(project, listener);
        }
    }

    private void fireWorkaround(IProject project) {
        HashBag hashBag = this.myListeners;
        synchronized (hashBag) {
            Iterator it = this.myListeners.get(project).iterator();
            while (it.hasNext()) {
                IProjectDependencyWorkaroundListener listener = (IProjectDependencyWorkaroundListener)it.next();
                listener.projectDependencyChanged(project);
            }
        }
    }

    private static class ClassPathChangeFinder
    implements IResourceDeltaVisitor {
        private Collection myCollectedProjects = new LinkedList();
        private boolean myProjectDependencyTreeNeedsRefresh;

        public ClassPathChangeFinder(boolean haveDependencyTree) {
            this.myProjectDependencyTreeNeedsRefresh = !haveDependencyTree;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 4: 
                case 8: {
                    this.myProjectDependencyTreeNeedsRefresh |= this.isDependencyTreeStale(delta);
                    return true;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    if (ProjectDependencyListener.CLASSPATH_PROJECT_RELATIVE_PATH.equals(resource.getProjectRelativePath().toString())) {
                        this.myCollectedProjects.add(resource.getProject());
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isDependencyTreeStale(IResourceDelta projectDelta) {
            switch (projectDelta.getKind()) {
                case 1: 
                case 2: {
                    return true;
                }
                case 4: {
                    if ((projectDelta.getFlags() & 0x84000) <= 0) break;
                    return true;
                }
            }
            return false;
        }

        public Collection getCollectedProjects() {
            return this.myCollectedProjects;
        }

        public boolean projectDependencyTreeNeedsRefresh() {
            return this.myProjectDependencyTreeNeedsRefresh;
        }
    }
}

