/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import com.tssap.j2ee.core.utils.IDispatchSessionListener;
import com.tssap.j2ee.core.utils.IDispatchedJavaDeltaListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;

public class JavaDeltaDispatcher
implements IElementChangedListener {
    private TreeMap myListeners = new TreeMap(new JavaElementComparator());
    private boolean myFiring;
    private Collection myDeferredListenerCommands = new ArrayList();
    private HashSet myDispatchSessionListeners = new HashSet();
    private static final JavaDeltaDispatcher myInstance = new JavaDeltaDispatcher();

    private JavaDeltaDispatcher() {
    }

    public static JavaDeltaDispatcher getInstance() {
        return myInstance;
    }

    public void reactivate() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1) {
            this.myFiring = true;
            try {
                HashSet hashSet;
                HashSet hashSet2 = this.myDispatchSessionListeners;
                synchronized (hashSet2) {
                    Iterator it = this.myDispatchSessionListeners.iterator();
                    while (it.hasNext()) {
                        ((IDispatchSessionListener)it.next()).deltaArrived();
                    }
                }
                try {
                    TreeMap treeMap = this.myListeners;
                    synchronized (treeMap) {
                        this.processDelta(event.getDelta());
                    }
                    Object var7_6 = null;
                    hashSet = this.myDispatchSessionListeners;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    HashSet hashSet3 = this.myDispatchSessionListeners;
                    synchronized (hashSet3) {
                        Iterator it = this.myDispatchSessionListeners.iterator();
                        while (it.hasNext()) {
                            ((IDispatchSessionListener)it.next()).deltaProcessed();
                        }
                    }
                }
                synchronized (hashSet) {
                    Iterator it = this.myDispatchSessionListeners.iterator();
                    while (it.hasNext()) {
                        ((IDispatchSessionListener)it.next()).deltaProcessed();
                    }
                }
                throw throwable;
                Object var12_15 = null;
                this.myFiring = false;
                this.processDeferredListeners();
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.myFiring = false;
                this.processDeferredListeners();
                throw throwable;
            }
        }
    }

    private void processDeferredListeners() {
        Iterator it = this.myDeferredListenerCommands.iterator();
        while (it.hasNext()) {
            ((Runnable)it.next()).run();
        }
        this.myDeferredListenerCommands.clear();
    }

    public void addDispatchedDeltaListener(final IJavaElement elementInInterest, final IDispatchedJavaDeltaListener listener) {
        if (this.myFiring) {
            this.myDeferredListenerCommands.add(new Runnable(){

                public void run() {
                    JavaDeltaDispatcher.this.addDispatchedDeltaListener(elementInInterest, listener);
                }
            });
            return;
        }
        TreeMap treeMap = this.myListeners;
        synchronized (treeMap) {
            HashSet<IDispatchedJavaDeltaListener> listenersForElement = (HashSet<IDispatchedJavaDeltaListener>)this.myListeners.get(elementInInterest);
            if (listenersForElement == null) {
                listenersForElement = new HashSet<IDispatchedJavaDeltaListener>();
                this.myListeners.put(elementInInterest, listenersForElement);
            }
            listenersForElement.add(listener);
        }
    }

    public void removeDispatchedDeltaListener(final IJavaElement elementInInterest, final IDispatchedJavaDeltaListener listener) {
        if (this.myFiring) {
            this.myDeferredListenerCommands.add(new Runnable(){

                public void run() {
                    JavaDeltaDispatcher.this.removeDispatchedDeltaListener(elementInInterest, listener);
                }
            });
            return;
        }
        TreeMap treeMap = this.myListeners;
        synchronized (treeMap) {
            Collection listenersForElement = (Collection)this.myListeners.get(elementInInterest);
            if (listenersForElement == null) {
                return;
            }
            listenersForElement.remove(listener);
        }
    }

    private void processDelta(IJavaElementDelta delta) {
        Collection listeners = (Collection)this.myListeners.get(delta.getElement());
        if (listeners != null) {
            this.notifyListeners(listeners, delta);
        }
        if (delta.getKind() == 4) {
            this.processChildren(delta);
        } else {
            this.processChildPaths(delta);
        }
    }

    private void processChildren(IJavaElementDelta delta) {
        if (this.tagPatch(delta)) {
            return;
        }
        IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < childDeltas.length) {
            this.processDelta(childDeltas[i]);
            ++i;
        }
    }

    private boolean tagPatch(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() == 5 && delta.getKind() == 4 && (delta.getFlags() & 1) > 0) {
            this.processChildPaths(delta);
            return true;
        }
        return false;
    }

    private void processChildPaths(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        SortedMap subMap = this.myListeners.tailMap(element);
        Iterator it = subMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            IJavaElement nextKey = (IJavaElement)next.getKey();
            if (!nextKey.getHandleIdentifier().startsWith(element.getHandleIdentifier())) break;
            this.notifyListeners((Collection)next.getValue(), delta);
        }
    }

    private void notifyListeners(Collection listeners, IJavaElementDelta delta) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ((IDispatchedJavaDeltaListener)it.next()).elementChanged(delta);
        }
    }

    public void addDispatchSessionListener(IDispatchSessionListener listener) {
        HashSet hashSet = this.myDispatchSessionListeners;
        synchronized (hashSet) {
            this.myDispatchSessionListeners.add(listener);
        }
    }

    public void removeDispatchSessionListener(IDispatchSessionListener listener) {
        HashSet hashSet = this.myDispatchSessionListeners;
        synchronized (hashSet) {
            this.myDispatchSessionListeners.remove(listener);
        }
    }

    private static class JavaElementComparator
    implements Comparator {
        private JavaElementComparator() {
        }

        public int compare(Object o1, Object o2) {
            IJavaElement e1 = (IJavaElement)o1;
            IJavaElement e2 = (IJavaElement)o2;
            return e1.getHandleIdentifier().compareTo(e2.getHandleIdentifier());
        }
    }
}

