/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import com.tssap.j2ee.internal.core.ejb.util.IMemberHolder;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import java.util.Map;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.formatter.CodeFormatter;

public class JavaCommentParserFactory {
    public static IJavaComment getJavaComment(IMember member) {
        if (member == null || !member.exists() || member.isBinary()) {
            return null;
        }
        IJavaComment result = JavaCommentsPlugin.getDefault().getJavaCommentParser();
        result.setSynchronizer((ISynchronizer)new MySynchronizer(member));
        return result;
    }

    private static class MySynchronizer
    implements ISynchronizer,
    IMemberHolder {
        private IMember myMember;

        public MySynchronizer(IMember member) {
            this.myMember = member;
        }

        public IMember getMember() {
            return this.myMember;
        }

        public String doSynchronizeFrom() {
            block10: {
                try {
                    String source = this.myMember.getSource();
                    if (source == null) break block10;
                    IDOMType domMember = null;
                    if (this.myMember instanceof IType) {
                        domMember = new DOMFactory().createType(source);
                    } else if (this.myMember instanceof IMethod) {
                        domMember = new DOMFactory().createMethod(source);
                    } else if (this.myMember instanceof IField) {
                        try {
                            domMember = new DOMFactory().createField(source);
                        }
                        catch (NullPointerException e) {
                            return null;
                        }
                    }
                    if (domMember != null) {
                        return domMember.getComment();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public void doSynchronizeTo(String content) {
            try {
                ICompilationUnit compilationUnit = this.myMember.getCompilationUnit();
                IBuffer buffer = compilationUnit.getBuffer();
                if (buffer == null) {
                    return;
                }
                char[] sourceCharsters = buffer.getCharacters();
                IDOMCompilationUnit domCompilationUnit = new DOMFactory().createCompilationUnit(sourceCharsters, compilationUnit.getElementName());
                IDOMNode domNode = JDTUtils.findNode((IDOMNode)domCompilationUnit, this.myMember);
                if (!(domNode instanceof IDOMMember)) {
                    return;
                }
                IDOMMember domMember = (IDOMMember)domNode;
                domMember.setComment(content);
                String newSource = domCompilationUnit.getContents();
                String formattedSource = new CodeFormatter((Map)null).format(newSource);
                buffer.setContents(formattedSource);
                buffer.save(null, true);
                compilationUnit.makeConsistent(null);
                compilationUnit.save(null, true);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }
}

