/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class JDomSupport {
    private static IDOMFactory myDomFactory;

    private JDomSupport() {
    }

    public static IDOMMethod getDomMethod(IMethod jdtMethod) throws JavaModelException {
        String source = jdtMethod.getSource();
        return JDomSupport.getDomFactory().createMethod(source);
    }

    public static boolean executeOperation(Operation operation, IMember jdtMember, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit compilationUnit = jdtMember.getCompilationUnit();
        IBuffer buffer = compilationUnit.getBuffer();
        if (buffer == null) {
            return false;
        }
        char[] sourceChars = buffer.getCharacters();
        IDOMCompilationUnit domCompilationUnit = JDomSupport.getDomFactory().createCompilationUnit(sourceChars, compilationUnit.getElementName());
        IDOMNode domNode = JDomSupport.findNode((IDOMNode)domCompilationUnit, jdtMember);
        if (domNode == null) {
            return false;
        }
        if (!operation.execute(jdtMember, domNode)) {
            return false;
        }
        sourceChars = domCompilationUnit.getCharacters();
        buffer.setContents(sourceChars);
        buffer.save(monitor, true);
        compilationUnit.makeConsistent(monitor);
        compilationUnit.save(monitor, true);
        return true;
    }

    private static IDOMNode findNode(IDOMNode domNode, IMember jdtMember) {
        String jdtContext = null;
        try {
            jdtContext = jdtMember.getSource();
        }
        catch (JavaModelException e) {
            return null;
        }
        IDOMField domMember = null;
        int elementType = jdtMember.getElementType();
        if (elementType == 8) {
            domMember = new DOMFactory().createField(jdtContext);
        } else if (elementType == 9) {
            domMember = new DOMFactory().createMethod(jdtContext);
        } else if (elementType == 7) {
            domMember = new DOMFactory().createType(jdtContext);
        }
        if (domMember == null) {
            return null;
        }
        if (domNode.isSignatureEqual((IDOMNode)domMember)) {
            return domNode;
        }
        Enumeration domNodeEnum = domNode.getChildren();
        while (domNodeEnum.hasMoreElements()) {
            IDOMNode childDomNode = (IDOMNode)domNodeEnum.nextElement();
            IDOMNode necessaryJavaElement = JDomSupport.findNode(childDomNode, jdtMember);
            if (necessaryJavaElement == null) continue;
            return necessaryJavaElement;
        }
        return null;
    }

    protected static IDOMFactory getDomFactory() {
        if (myDomFactory == null) {
            myDomFactory = new DOMFactory();
        }
        return myDomFactory;
    }

    public static interface Operation {
        public boolean execute(IMember var1, IDOMNode var2);
    }
}

