/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import com.tssap.j2ee.internal.core.ejb.util.AddMethodAction;
import com.tssap.j2ee.internal.core.ejb.util.AddUnimplementedMethodsAction;
import com.tssap.j2ee.internal.core.ejb.util.IPackageProcessor;
import com.tssap.j2ee.internal.core.ejb.util.JDomSupport;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;

public class JDTUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String COMPILATION_UNIT_SUFFIX = ".java";
    public static final IMethod[] NO_METHODS = new IMethod[0];
    public static final IType[] NO_TYPES = new IType[0];
    public static final String ARRAY_SUFFIX = "[]";

    public static Object processPackages(IJavaProject project, String packageQualifiedName, IPackageProcessor processor) {
        IPackageFragmentRoot[] roots;
        if (packageQualifiedName == null) {
            return null;
        }
        try {
            roots = project.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            return null;
        }
        Object result = null;
        int i = 0;
        while (result == null && i < roots.length) {
            IPackageFragment fragment = roots[i].getPackageFragment(packageQualifiedName);
            if (fragment.exists()) {
                result = roots[i].isArchive() ? processor.processBinaryPackage(fragment) : processor.processSourcePackage(fragment);
            }
            ++i;
        }
        return result;
    }

    public static IType findType(IJavaProject project, String packageQualifiedName, final String className) {
        return (IType)JDTUtils.processPackages(project, packageQualifiedName, new IPackageProcessor(){

            public Object processBinaryPackage(IPackageFragment fragment) {
                try {
                    IType result = fragment.getClassFile(className + ".class").getType();
                    if (result.exists()) {
                        return result;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                return null;
            }

            public Object processSourcePackage(IPackageFragment fragment) {
                IType result = fragment.getCompilationUnit(className + JDTUtils.COMPILATION_UNIT_SUFFIX).getType(className);
                if (result.exists()) {
                    return result;
                }
                return null;
            }
        });
    }

    public static IType findType(IJavaProject project, String fullQualifiedName) {
        String beanName;
        String packageName;
        int lastDot = fullQualifiedName.lastIndexOf(46);
        if (lastDot == -1) {
            packageName = "";
            beanName = fullQualifiedName;
        } else {
            packageName = fullQualifiedName.substring(0, lastDot);
            beanName = fullQualifiedName.substring(lastDot + 1);
        }
        return JDTUtils.findType(project, packageName, beanName);
    }

    public static IPackageFragment getSourcePackage(IJavaProject javaProject, String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        String packageFQN = lastDotIndex == -1 ? "" : typeFQN.substring(0, lastDotIndex);
        return JDTUtils.findSourcePackage(javaProject, packageFQN);
    }

    public static IPackageFragment findSourcePackage(IJavaProject javaProject, String packageFQN) {
        IPackageFragment typePackage = (IPackageFragment)JDTUtils.processPackages(javaProject, packageFQN, new IPackageProcessor(){

            public Object processSourcePackage(IPackageFragment fragment) {
                return fragment;
            }

            public Object processBinaryPackage(IPackageFragment fragment) {
                return null;
            }
        });
        return typePackage;
    }

    public static void deleteType(IType type) throws JavaModelException {
        ICompilationUnit cu;
        IType[] types;
        if (type == null || !type.exists() || type.isBinary()) {
            return;
        }
        if (type.getDeclaringType() != null) {
            type.delete(false, null);
        }
        if ((types = (cu = type.getCompilationUnit()).getTypes()).length != 1) {
            type.delete(false, null);
        }
        cu.delete(false, null);
    }

    public static String getTypeName(String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        return lastDotIndex == -1 ? typeFQN : typeFQN.substring(lastDotIndex + 1);
    }

    public static String getPackageName(String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        return lastDotIndex == -1 ? "" : typeFQN.substring(0, lastDotIndex);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            throw new RuntimeException("Must not happen");
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String uncapitalize(String name) {
        if (name == null || name.length() == 0) {
            throw new RuntimeException("Must not happen");
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String getFieldNameByAccessor(IMethod accessor) {
        String result = accessor.getElementName();
        if (result.startsWith(SETTER_PREFIX)) {
            result = result.substring(SETTER_PREFIX.length());
        } else if (result.startsWith(GETTER_PREFIX)) {
            result = result.substring(GETTER_PREFIX.length());
        } else {
            throw new IllegalArgumentException("Method is not an accessor");
        }
        return JDTUtils.uncapitalize(result);
    }

    public static String getGetterName(IField field) {
        return JDTUtils.getGetterName(field.getElementName());
    }

    public static String getGetterName(String fieldName) {
        return GETTER_PREFIX + JDTUtils.capitalize(fieldName);
    }

    public static String getSetterName(IField field) {
        return JDTUtils.getSetterName(field.getElementName());
    }

    public static String getSetterName(String fieldName) {
        return SETTER_PREFIX + JDTUtils.capitalize(fieldName);
    }

    public static boolean isAccessor(IMethod accessor) {
        return JDTUtils.isGetter(accessor) || JDTUtils.isSetter(accessor);
    }

    public static boolean isSetter(IMethod accessor) {
        String name = accessor.getElementName();
        if (!name.startsWith(SETTER_PREFIX)) {
            return false;
        }
        if (name.length() == SETTER_PREFIX.length() || !Character.isUpperCase(name.charAt(SETTER_PREFIX.length()))) {
            return false;
        }
        if (accessor.getParameterTypes().length != 1) {
            return false;
        }
        try {
            if (!accessor.exists()) {
                return true;
            }
            if (!accessor.getReturnType().equals("V")) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    public static boolean isGetter(IMethod accessor) {
        String name = accessor.getElementName();
        if (!name.startsWith(GETTER_PREFIX)) {
            return false;
        }
        if (name.length() == GETTER_PREFIX.length() || !Character.isUpperCase(name.charAt(GETTER_PREFIX.length()))) {
            return false;
        }
        if (accessor.getParameterTypes().length != 0) {
            return false;
        }
        try {
            if (!accessor.exists()) {
                return true;
            }
            if (accessor.getReturnType().equals("V")) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    public static String getGetterType(IMethod getter) {
        try {
            return Signature.toString((String)getter.getReturnType());
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public static String getSetterType(IMethod setter) {
        if (!JDTUtils.isSetter(setter)) {
            return null;
        }
        return Signature.toString((String)setter.getParameterTypes()[0]);
    }

    public static String[] java2jdt(String[] javaTypes, boolean resolved) {
        String[] jdtTypes = (String[])javaTypes.clone();
        int i = 0;
        while (i < jdtTypes.length) {
            jdtTypes[i] = Signature.createTypeSignature((String)jdtTypes[i], (boolean)resolved);
            ++i;
        }
        return jdtTypes;
    }

    public static String[] jdt2java(String[] jdtTypes) {
        String[] javaTypes = (String[])jdtTypes.clone();
        int i = 0;
        while (i < javaTypes.length) {
            javaTypes[i] = Signature.toString((String)javaTypes[i]);
            ++i;
        }
        return javaTypes;
    }

    public static String generateDefaultName(IPackageFragment fragment, String namePrefix) {
        ICompilationUnit[] units;
        try {
            units = fragment.getCompilationUnits();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            units = new ICompilationUnit[]{};
        }
        HashSet<String> typeNames = new HashSet<String>();
        int i = 0;
        while (i < units.length) {
            IType[] types;
            try {
                types = units[i].getTypes();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                types = new IType[]{};
            }
            int j = 0;
            while (j < types.length) {
                typeNames.add(types[j].getElementName());
                ++j;
            }
            ++i;
        }
        int i2 = 1;
        String possibleName;
        while (typeNames.contains(possibleName = namePrefix + i2)) {
            ++i2;
        }
        return possibleName;
    }

    public static IType createType(final IPackageFragment fragment, final String className, final String baseClassName, final String[] interfaceNames, final boolean addConstructors, final boolean addUnimplementedMethods, IProgressMonitor m) {
        final IType[] resultHolder = new IType[1];
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;

                public void run(IProgressMonitor monitor) throws CoreException {
                    IType[] superinterfaces;
                    Entity pak = (Entity)fragment.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = 3.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
                    Entity template = pak.getModel().createEntityTemplate();
                    template.setPropertyValue("$name", className);
                    Entity clz = pak.createChildEntity("Class", template);
                    resultHolder[0] = (IType)ElementUtil.getJavaElement((Element)clz);
                    IType superclass = baseClassName == null ? null : fragment.getJavaProject().findType(baseClassName);
                    if (interfaceNames == null) {
                        superinterfaces = null;
                    } else {
                        ArrayList<IType> superinterfacesAsITypes = new ArrayList<IType>();
                        int i = 0;
                        while (i < interfaceNames.length) {
                            IType type = fragment.getJavaProject().findType(interfaceNames[i]);
                            if (type != null) {
                                superinterfacesAsITypes.add(type);
                            }
                            ++i;
                        }
                        superinterfaces = superinterfacesAsITypes.toArray(new IType[superinterfacesAsITypes.size()]);
                    }
                    JDTUtils.setExtendsImplementsClause(resultHolder[0], superclass, true, superinterfaces, true, addConstructors, addUnimplementedMethods, null);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            }, m);
        }
        catch (CoreException e) {
            return null;
        }
        return resultHolder[0];
    }

    public static void setExtendsImplementsClause(IType recipient, IType superclass, final boolean changeSuperclass, IType[] superinterfaces, final boolean changeSuperinterfaces, boolean addConstructors, boolean addUnimplementedMethods, IOverrideMethodQuery query) throws CoreException {
        String[] simpleInterfaceNames;
        String[] interfaceNames;
        String baseClassName;
        boolean isInterface = recipient.isInterface();
        ICompilationUnit cu = recipient.getCompilationUnit();
        ICompilationUnit wc = (ICompilationUnit)cu.getWorkingCopy();
        IType wcType = (IType)JDTUtils.getWorkingCopyElement((IWorkingCopy)wc, (IMember)recipient);
        if (changeSuperclass && superclass != null) {
            String baseClassNameNotFinal = superclass.getFullyQualifiedName();
            if (baseClassNameNotFinal != null && JDTUtils.addImport(wc, baseClassNameNotFinal)) {
                baseClassNameNotFinal = JDTUtils.getTypeName(baseClassNameNotFinal);
            }
            baseClassName = baseClassNameNotFinal;
        } else {
            baseClassName = null;
        }
        if (changeSuperinterfaces && superinterfaces != null) {
            interfaceNames = new String[superinterfaces.length];
            int i = 0;
            while (i < superinterfaces.length) {
                interfaceNames[i] = superinterfaces[i].getFullyQualifiedName();
                ++i;
            }
        } else {
            interfaceNames = null;
        }
        if (interfaceNames != null && interfaceNames.length > 0) {
            simpleInterfaceNames = new String[interfaceNames.length];
            int i = 0;
            while (i < interfaceNames.length) {
                simpleInterfaceNames[i] = JDTUtils.addImport(wc, interfaceNames[i]) ? JDTUtils.getTypeName(interfaceNames[i]) : interfaceNames[i];
                ++i;
            }
        } else {
            simpleInterfaceNames = null;
        }
        if (wcType != null) {
            JDomSupport.executeOperation(new JDomSupport.Operation(){

                public boolean execute(IMember jdtMember, IDOMNode domNode) {
                    if (domNode == null || domNode.getNodeType() != 4) {
                        return false;
                    }
                    IDOMType domType = (IDOMType)domNode;
                    if (changeSuperclass) {
                        if (baseClassName != null && !"java.lang.Object".equals(baseClassName) && !"Object".equals(baseClassName)) {
                            domType.setSuperclass(baseClassName);
                        } else {
                            domType.setSuperclass(null);
                        }
                    }
                    if (changeSuperinterfaces && simpleInterfaceNames != null && simpleInterfaceNames.length > 0) {
                        domType.setSuperInterfaces(simpleInterfaceNames);
                    }
                    return true;
                }
            }, (IMember)wcType, (IProgressMonitor)new NullProgressMonitor());
            if (wc.hasUnsavedChanges()) {
                wc.save(null, false);
                wc.makeConsistent(null);
                wc.commit(false, null);
                wc.destroy();
            }
            if (!isInterface) {
                JDTUtils.addUnimplementedMethods(recipient, addConstructors, addUnimplementedMethods, query);
            }
        }
    }

    private static IMember getWorkingCopyElement(IWorkingCopy wc, IMember element) {
        IJavaElement[] wcElements = wc.findElements((IJavaElement)element);
        if (wcElements == null || wcElements.length != 1) {
            return null;
        }
        IJavaElement wcElement = wcElements[0];
        if (wcElement instanceof IMember) {
            return (IMember)wcElement;
        }
        return null;
    }

    public static void addUnimplementedMethods(IType type) throws CoreException {
        JDTUtils.addUnimplementedMethods(type, true, true, null);
    }

    public static void addUnimplementedMethods(IType type, boolean addConstructors, boolean addAbstractMethods, IOverrideMethodQuery query) throws CoreException {
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new AddUnimplementedMethodsAction(type, addConstructors, addAbstractMethods, query), (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addMethod(IType type, IMethod overriddenMethod, IProgressMonitor m) throws CoreException {
        new AddMethodAction(type, overriddenMethod).run(m);
    }

    public static String getPublicTypeName(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        String cuName = cu.getElementName();
        if (!cuName.endsWith(COMPILATION_UNIT_SUFFIX)) {
            return null;
        }
        return cuName.substring(0, cuName.length() - COMPILATION_UNIT_SUFFIX.length());
    }

    public static String getFQN(IType context, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.indexOf(46) != -1) {
            return typeName;
        }
        String typeSig = Signature.createTypeSignature((String)typeName, (boolean)false);
        int arrayCount = Signature.getArrayCount((String)typeSig);
        String arraylessTypeName = Signature.toString((String)Signature.getElementType((String)typeSig));
        if (JDTUtils.isSimpleType(arraylessTypeName)) {
            return typeName;
        }
        try {
            String[][] resolved = context.resolveType(arraylessTypeName);
            if (resolved == null || resolved.length != 1) {
                return typeName;
            }
            if (resolved[0][0].length() == 0) {
                return JDTUtils.addArrays(resolved[0][1], arrayCount);
            }
            return JDTUtils.addArrays(resolved[0][0] + '.' + resolved[0][1], arrayCount);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return typeName;
        }
    }

    private static String stripArrays(String typeName) {
        if (!typeName.endsWith(ARRAY_SUFFIX)) {
            return typeName;
        }
        String typeSig = Signature.createTypeSignature((String)typeName, (boolean)false);
        return Signature.toString((String)Signature.getElementType((String)typeSig));
    }

    private static String addArrays(String typeName, int arrayCount) {
        if (arrayCount == 0) {
            return typeName;
        }
        StringBuffer buf = new StringBuffer(typeName);
        int i = 0;
        while (i < arrayCount) {
            buf.append(ARRAY_SUFFIX);
            ++i;
        }
        return buf.toString();
    }

    public static boolean addImport(IType type, String importedFQN) {
        ICompilationUnit cu = type.getCompilationUnit();
        return JDTUtils.addImport(cu, importedFQN);
    }

    public static boolean addImport(ICompilationUnit cu, String importedFQN) {
        Boolean conflict = JDTUtils.isConflictingImport(cu, importedFQN = JDTUtils.stripArrays(importedFQN));
        if (conflict != null) {
            return conflict == false;
        }
        String packageName = JDTUtils.getPackageName(importedFQN);
        if ("java.lang".equals(packageName)) {
            return true;
        }
        if ((packageName == null || packageName.length() == 0) && JDTUtils.findType(cu.getJavaProject(), importedFQN) == null) {
            return false;
        }
        String typePackageName = cu.getParent().getElementName();
        if (packageName.equals(typePackageName)) {
            return true;
        }
        try {
            cu.createImport(importedFQN, null, null);
            return true;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean addImport(IJavaProject javaProject, String typePackageName, IDOMCompilationUnit cu, String importedFQN) {
        Boolean conflict = JDTUtils.isConflictingImport(cu, importedFQN = JDTUtils.stripArrays(importedFQN));
        if (conflict != null) {
            return conflict == false;
        }
        String packageName = JDTUtils.getPackageName(importedFQN);
        if ("java.lang".equals(packageName)) {
            return true;
        }
        if ((packageName == null || packageName.length() == 0) && JDTUtils.findType(javaProject, importedFQN) == null) {
            return false;
        }
        if (packageName.equals(typePackageName)) {
            return true;
        }
        String cuName = cu.getName();
        IDOMType type = (IDOMType)cu.getChild(cuName.substring(0, cuName.length() - COMPILATION_UNIT_SUFFIX.length()));
        if (type == null) {
            return false;
        }
        type.insertSibling((IDOMNode)new DOMFactory().createImport("import " + importedFQN + ";" + System.getProperty("line.separator")));
        return true;
    }

    private static Boolean isConflictingImport(ICompilationUnit cu, String importedFQN) {
        String simpleTypeName = Signature.getSimpleName((String)importedFQN);
        try {
            IImportDeclaration[] decls = cu.getImports();
            int i = 0;
            while (i < decls.length) {
                if (!decls[i].isOnDemand() && Signature.getSimpleName((String)decls[i].getElementName()).equals(simpleTypeName)) {
                    return new Boolean(!decls[i].getElementName().equals(importedFQN));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            return Boolean.TRUE;
        }
        return null;
    }

    private static Boolean isConflictingImport(IDOMCompilationUnit cu, String importedFQN) {
        String simpleTypeName = Signature.getSimpleName((String)importedFQN);
        Enumeration enumeration = cu.getChildren();
        while (enumeration.hasMoreElements()) {
            IDOMImport imp;
            IDOMNode next = (IDOMNode)enumeration.nextElement();
            if (!(next instanceof IDOMImport) || (imp = (IDOMImport)next).isOnDemand() || !Signature.getSimpleName((String)imp.getName()).equals(simpleTypeName)) continue;
            return new Boolean(!imp.getName().equals(importedFQN));
        }
        return null;
    }

    public static IDOMNode findNode(IDOMNode domNode, IMember jdtMember) {
        String jdtContext = null;
        try {
            jdtContext = jdtMember.getSource();
        }
        catch (JavaModelException e) {
            return null;
        }
        IDOMField domMember = null;
        int elementType = jdtMember.getElementType();
        if (elementType == 8) {
            domMember = new DOMFactory().createField(jdtContext);
        } else if (elementType == 9) {
            domMember = new DOMFactory().createMethod(jdtContext);
        } else if (elementType == 7) {
            domMember = new DOMFactory().createType(jdtContext);
        }
        if (domMember == null) {
            return null;
        }
        return JDTUtils.findNode(domNode, (IDOMMember)domMember);
    }

    public static IDOMNode findNode(IDOMNode domNode, IDOMMember domMember) {
        if (domNode.isSignatureEqual((IDOMNode)domMember)) {
            return domNode;
        }
        Enumeration domNodeEnum = domNode.getChildren();
        while (domNodeEnum.hasMoreElements()) {
            IDOMNode childDomNode = (IDOMNode)domNodeEnum.nextElement();
            IDOMNode necessaryJavaElement = JDTUtils.findNode(childDomNode, domMember);
            if (necessaryJavaElement == null) continue;
            return necessaryJavaElement;
        }
        return null;
    }

    public static IMethod findMethod(IType type, String name, String[] parameterTypeFQNs) {
        IMethod[] methods;
        try {
            methods = type.getMethods();
        }
        catch (JavaModelException e) {
            return null;
        }
        int i = 0;
        while (i < methods.length) {
            String[] parameterTypeSigs;
            if (name.equals(methods[i].getElementName()) && JDTUtils.sameResolvedParameterTypes(type, parameterTypeFQNs, parameterTypeSigs = methods[i].getParameterTypes())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean sameResolvedParameterTypes(IType type, String[] parameterTypeFQNs, String[] parameterTypeSigs) {
        if (parameterTypeFQNs.length != parameterTypeSigs.length) {
            return false;
        }
        int i = 0;
        while (i < parameterTypeFQNs.length) {
            String param = Signature.toString((String)parameterTypeSigs[i]);
            if (!parameterTypeFQNs[i].equals(param)) {
                if (!Signature.getSimpleName((String)parameterTypeFQNs[i]).equals(param)) {
                    return false;
                }
                if (!parameterTypeFQNs[i].equals(JDTUtils.getFQN(type, param))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isSimpleType(String typeName) {
        return typeName != null && Signature.createTypeSignature((String)typeName, (boolean)true).length() == 1;
    }
}

