/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import com.tssap.j2ee.internal.core.ejb.util.DetailedHierarchyChangedEvent;
import com.tssap.j2ee.internal.core.ejb.util.IDetailedHierarchyChangedListener;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.workarounds.IProjectDependencyWorkaroundListener;
import com.tssap.j2ee.internal.core.ejb.workarounds.ProjectDependencyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class AutoRefreshableTypeHierarchy
implements ITypeHierarchyChangedListener,
IProjectDependencyWorkaroundListener {
    private ITypeHierarchy myHierarchy;
    private IType myType;
    private String myTypeName;
    private IJavaProject myProject;
    private HashSet myListeners = new HashSet();
    private Collection myCachedAllTypes;
    private boolean myRefreshNeeded;

    public AutoRefreshableTypeHierarchy(IJavaProject project, String className) {
        this.myTypeName = className;
        this.myProject = project;
        ProjectDependencyListener.getInstance().addWorkaroundListener(this.myProject.getProject(), this);
        this.createHierarchy();
    }

    private void createHierarchy() {
        if (this.myHierarchy != null) {
            return;
        }
        if (this.myType == null || !this.myType.exists()) {
            this.myType = JDTUtils.findType(this.myProject, this.myTypeName);
            if (this.myType == null) {
                return;
            }
        }
        try {
            this.myHierarchy = this.myType.newTypeHierarchy(this.myProject, null);
            this.myHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        catch (JavaModelException e) {
            this.myHierarchy = null;
        }
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    public synchronized ITypeHierarchy getHierarchy() {
        this.createHierarchy();
        this.updateHierarchyIfDeferred();
        return this.myHierarchy;
    }

    private void updateHierarchyIfDeferred() {
        if (this.myRefreshNeeded) {
            this.myRefreshNeeded = false;
            this.rebuildHierarchy();
        }
    }

    public synchronized void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        Assert.isLegal((this.myHierarchy == typeHierarchy ? 1 : 0) != 0);
        if (this.myListeners.isEmpty()) {
            this.myRefreshNeeded = true;
            return;
        }
        this.rebuildHierarchy();
    }

    private void forgetHierarchy() {
        if (this.myHierarchy != null) {
            this.myHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.myHierarchy = null;
        }
        this.myType = null;
    }

    public void projectDependencyChanged(IProject project) {
        if (this.myListeners.isEmpty()) {
            this.myRefreshNeeded = true;
            return;
        }
        this.rebuildHierarchy();
    }

    public boolean exists() {
        return this.myHierarchy != null;
    }

    private void rebuildHierarchy() {
        Collection oldTypes = this.getAllTypes();
        this.flushCache();
        this.forgetHierarchy();
        this.createHierarchy();
        Collection newTypes = this.getAllTypes();
        this.fire(oldTypes, newTypes);
    }

    public IType getType() {
        return this.myType;
    }

    public Collection getAllTypes() {
        this.updateHierarchyIfDeferred();
        if (this.myCachedAllTypes == null) {
            this.myCachedAllTypes = this.myHierarchy == null ? Collections.EMPTY_LIST : Arrays.asList(this.myHierarchy.getAllSubtypes(this.myHierarchy.getType()));
        }
        return this.myCachedAllTypes;
    }

    public Collection getAllClasses() {
        ArrayList<IType> result = new ArrayList<IType>();
        Iterator it = this.getAllTypes().iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            try {
                if (!next.isClass()) continue;
                result.add(next);
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean contains(IType type) {
        this.updateHierarchyIfDeferred();
        if (this.myHierarchy == null) {
            return false;
        }
        return this.myHierarchy.contains(type);
    }

    private void flushCache() {
        this.myCachedAllTypes = null;
    }

    public void addHierarchyListener(IDetailedHierarchyChangedListener listener) {
        this.myListeners.add(listener);
        this.updateHierarchyIfDeferred();
    }

    public void removeHierarchyListener(IDetailedHierarchyChangedListener listener) {
        this.myListeners.remove(listener);
    }

    protected void fire(Collection oldTypes, Collection newTypes) {
        if (this.myListeners.size() == 0) {
            return;
        }
        ArrayList commonTypes = new ArrayList(oldTypes);
        commonTypes.retainAll(newTypes);
        ArrayList addedTypes = new ArrayList(newTypes);
        addedTypes.removeAll(commonTypes);
        ArrayList removedTypes = new ArrayList(oldTypes);
        removedTypes.removeAll(commonTypes);
        if (addedTypes.size() + removedTypes.size() == 0) {
            return;
        }
        DetailedHierarchyChangedEvent evt = new DetailedHierarchyChangedEvent(this, addedTypes, removedTypes);
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((IDetailedHierarchyChangedListener)it.next()).hierarchyChanged(evt);
        }
    }

    public void update() {
        this.rebuildHierarchy();
    }
}

