/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.util;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.formatter.CodeFormatter;
import org.eclipse.jdt.internal.ui.preferences.ImportOrganizePreferencePage;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;

public class AddUnimplementedMethodsAction
implements IWorkspaceRunnable {
    private IType myType;
    private boolean myAddConstructors;
    private boolean myAddAbstractMethods;
    private IOverrideMethodQuery myQuery;

    public AddUnimplementedMethodsAction(IType type, boolean addConstructors, boolean addAbstractMethods, IOverrideMethodQuery query) {
        this.myType = type;
        this.myAddConstructors = addConstructors;
        this.myAddAbstractMethods = addAbstractMethods;
        this.myQuery = query;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this.myAddAbstractMethods || this.myAddConstructors) {
            String[] unimplemented;
            String[] constructors;
            IType superclass;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ArrayList<String> newMethods = new ArrayList<String>();
            ITypeHierarchy hierarchy = this.myType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            String[] prefOrder = ImportOrganizePreferencePage.getImportOrderPreference();
            int threshold = ImportOrganizePreferencePage.getImportNumberThreshold();
            ImportsStructure importsStructure = new ImportsStructure(this.myType.getCompilationUnit(), prefOrder, threshold, true);
            importsStructure.create(false, null);
            if (this.myAddConstructors && (superclass = hierarchy.getSuperclass(this.myType)) != null && (constructors = StubUtility.evalConstructors((IType)this.myType, (IType)superclass, (CodeGenerationSettings)settings, (IImportsStructure)importsStructure)) != null) {
                int i = 0;
                while (i < constructors.length) {
                    newMethods.add(constructors[i]);
                    ++i;
                }
            }
            if (this.myAddAbstractMethods && (unimplemented = StubUtility.evalUnimplementedMethods((IType)this.myType, (ITypeHierarchy)hierarchy, (boolean)false, (CodeGenerationSettings)settings, (IOverrideMethodQuery)this.myQuery, (IImportsStructure)importsStructure)) != null) {
                int i = 0;
                while (i < unimplemented.length) {
                    newMethods.add(unimplemented[i]);
                    ++i;
                }
            }
            if (newMethods.size() > 0) {
                int i = 0;
                while (i < newMethods.size()) {
                    String content = (String)newMethods.get(i) + '\n';
                    this.myType.createMethod(content, null, false, null);
                    ++i;
                }
                importsStructure.create(true, null);
                String formatted = new CodeFormatter((Map)null).format(this.myType.getCompilationUnit().getSource());
                IBuffer buffer = this.myType.getCompilationUnit().getBuffer();
                buffer.setContents(formatted);
                buffer.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                this.myType.getCompilationUnit().makeConsistent((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
    }
}

