/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceProducer;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.JavaOccurrenceImpl;
import com.tssap.j2ee.core.utils.refactoring.TextResourceOccurrencesImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;

public class TextSearchCollector
implements ITextSearchResultCollector {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private String myNewName;
    private IMember myMember;
    private IResourceOccurrenceProducer myProducer;
    private static final IResourceOccurrenceCreator CREATOR = new IResourceOccurrenceCreator(){

        public IResourceOccurrences createResourceOccurrence(IFile resource) {
            return new TextResourceOccurrencesImpl(resource);
        }
    };

    public TextSearchCollector(IResourceOccurrenceProducer producer, IMember member, String newName) {
        this.myNewName = newName;
        this.myMember = member;
        this.myProducer = producer;
    }

    public IProgressMonitor getProgressMonitor() {
        return NULL_MONITOR;
    }

    public void aboutToStart() throws CoreException {
    }

    public void accept(IResource resource, String line, int start, int length, int lineNumber) throws CoreException {
        if (resource == null || resource.getType() != 1) {
            return;
        }
        try {
            IFile file = (IFile)resource;
            IResourceOccurrences occurrences = this.myProducer.getOccurrences(file, CREATOR);
            occurrences.addOccurrence(this.createJavaOccurrence(file, start, length, this.myNewName));
        }
        catch (IllegalArgumentException e) {
            this.myProducer.setFailed();
        }
    }

    public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
        if (proxy == null || proxy.getType() != 1) {
            return;
        }
        this.accept(proxy.requestResource(), line, start, length, lineNumber);
    }

    public void done() throws CoreException {
    }

    private IOccurrence createJavaOccurrence(IFile file, int start, int length, String newName) {
        return new JavaOccurrenceImpl(file, this.myMember, null, start, start + length, newName);
    }
}

