/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.utils.refactoring.AbstractResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.ITextOccurrence;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TextResourceOccurrencesImpl
extends AbstractResourceOccurrences {
    private SortedSet myOccurrences = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo(o2);
        }
    });
    private String myOldContents;
    static /* synthetic */ Class class$com$tssap$j2ee$core$utils$refactoring$ITextOccurrence;

    public TextResourceOccurrencesImpl(IFile resource) {
        super(resource);
    }

    public void addOccurrence(IOccurrence occurrence) {
        this.preAddOccurrence(occurrence, class$com$tssap$j2ee$core$utils$refactoring$ITextOccurrence == null ? (class$com$tssap$j2ee$core$utils$refactoring$ITextOccurrence = TextResourceOccurrencesImpl.class$("com.tssap.j2ee.core.utils.refactoring.ITextOccurrence")) : class$com$tssap$j2ee$core$utils$refactoring$ITextOccurrence);
        this.myOccurrences.add(occurrence);
    }

    public boolean canPerformNaive() {
        return super.canPerformNaive() && this.checkNonOverlapping();
    }

    private boolean checkNonOverlapping() {
        int nextAllowedEnd = Integer.MAX_VALUE;
        Iterator it = this.myOccurrences.iterator();
        while (it.hasNext()) {
            ITextOccurrence next = (ITextOccurrence)it.next();
            if (next.getEnd() >= nextAllowedEnd) {
                return false;
            }
            nextAllowedEnd = next.getStart();
        }
        return true;
    }

    public void perform(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.myOccurrences.isEmpty()) {
            monitor.done();
            return;
        }
        try {
            this.myOldContents = FileUtils.getFileContents(this.getFile());
            if (this.myOldContents.length() < this.getLastChangeEnd()) {
                throw this.newCoreException("There are changes behind the end of file", null);
            }
            monitor.beginTask("Performing change", this.myOccurrences.size() + 1);
            String contents = this.replaceOccurrences(this.myOldContents);
            this.writeContents(contents, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.performed();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void undo(IProgressMonitor monitor) throws CoreException {
        try {
            this.writeUndoContents(this.myOldContents, monitor);
            Object var3_2 = null;
            if (monitor == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected void writeContents(String contents, IProgressMonitor monitor) throws CoreException {
        this.getFile().setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), false, true, monitor);
    }

    protected void writeUndoContents(String contents, IProgressMonitor monitor) throws CoreException {
        this.writeContents(contents, monitor);
    }

    private int getLastChangeEnd() {
        if (this.myOccurrences.isEmpty()) {
            return -1;
        }
        return ((ITextOccurrence)this.myOccurrences.first()).getEnd();
    }

    private String replaceOccurrences(String contents) {
        StringBuffer buf = new StringBuffer(contents);
        Iterator it = this.myOccurrences.iterator();
        while (it.hasNext()) {
            ITextOccurrence next = (ITextOccurrence)it.next();
            int start = next.getStart();
            int end = next.getEnd();
            String nextOccurrence = contents.substring(start, end);
            String newName = next.getNewName();
            String oldName = next.getOldName();
            if (oldName != null && nextOccurrence.startsWith(oldName)) {
                end = start + oldName.length();
            }
            buf.replace(start, end, newName);
        }
        return buf.toString();
    }

    public IOccurrence[] getAllOccurrences() {
        return this.myOccurrences.toArray(new IOccurrence[this.myOccurrences.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

