/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.refactoring.TextResourceOccurrencesImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class RenamingCompilationUnitTextOccurrenceImpl
extends TextResourceOccurrencesImpl {
    private String myNewName;
    private String myOldName;
    private IFile myNewFile;

    public RenamingCompilationUnitTextOccurrenceImpl(IFile resource, String oldName, String newName) {
        super(resource);
        this.myOldName = oldName;
        this.myNewName = newName;
        this.myNewFile = this.getFile().getParent().getFile((IPath)new Path(this.myNewName + ".java"));
    }

    public boolean canPerform() {
        if (!super.canPerform()) {
            return false;
        }
        return this.getFile().getParent().findMember(this.myNewName + ".java") == null;
    }

    protected void writeContents(String contents, IProgressMonitor monitor) throws CoreException {
        contents = this.changeMainTypeName(contents);
        monitor.beginTask("Writing contents", 2);
        this.getFile().move(this.myNewFile.getFullPath(), false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.myNewFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private String changeMainTypeName(String contents) {
        IDOMCompilationUnit cu = new DOMFactory().createCompilationUnit(contents, this.getFile().getName());
        if (cu == null) {
            return contents;
        }
        IDOMNode node = cu.getChild(this.myOldName);
        if (node == null) {
            return contents;
        }
        if (node.getNodeType() == 4) {
            node.setName(this.myNewName);
        }
        return cu.getContents();
    }

    protected void writeUndoContents(String contents, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Writing contents", 2);
        if (this.myNewFile.exists()) {
            this.myNewFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.myNewFile.move(this.getFile().getFullPath(), false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else if (this.getFile().exists()) {
            this.getFile().setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), false, true, monitor);
        } else {
            this.getFile().create((InputStream)new ByteArrayInputStream(contents.getBytes()), false, monitor);
        }
    }

    public boolean isMoveOccurrence() {
        return true;
    }
}

