/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.utils.refactoring.AbstractChangePerformer;
import com.tssap.j2ee.core.utils.refactoring.JavaFilesSearchScope;
import com.tssap.j2ee.core.utils.refactoring.JavaSearchCollector;
import com.tssap.j2ee.core.utils.refactoring.RenamingCompilationUnitTextOccurrenceImpl;
import com.tssap.j2ee.core.utils.refactoring.TextSearchCollector;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.TextSearchEngine;

public class Refactorer
extends AbstractChangePerformer {
    private HashMap myRefactoringSchemes = new HashMap();
    private int myLimit = 3;
    private static final String START = "<{";
    private static final String END = "}>";

    public void addRefactoringScheme(IMember je, String newName) {
        this.myRefactoringSchemes.put(je, newName);
        if (je.getElementType() == 7 && je.getParent().getElementType() == 5) {
            IResource resource = je.getCompilationUnit().getResource();
            if (resource != null && resource.getType() == 1) {
                this.putResourceOccurrences((IFile)resource, new RenamingCompilationUnitTextOccurrenceImpl((IFile)resource, je.getElementName(), newName));
            }
            try {
                IType type = (IType)je;
                IMethod[] constructors = type.getMethods();
                int i = 0;
                while (i < constructors.length) {
                    if (constructors[i].isConstructor()) {
                        this.myRefactoringSchemes.put(constructors[i], newName);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                UtilsPlugin.logWarning("Failed to find all occurrences while processing refactoring precondition", e);
                this.setFailed();
            }
        }
        if (je.getElementType() == 9) {
            try {
                IMethod[] relatedMethods = RippleMethodFinder.getRelatedMethods((IMethod)((IMethod)je), (IProgressMonitor)new NullProgressMonitor(), (IWorkingCopy[])new IWorkingCopy[0]);
                int i = 0;
                while (i < relatedMethods.length) {
                    this.myRefactoringSchemes.put(relatedMethods[i], newName);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                UtilsPlugin.logWarning("Failed to find all occurrences while processing refactoring precondition", e);
                this.setFailed();
            }
        }
    }

    protected void performed() {
    }

    protected void doCreateResourceOccurrences() throws IllegalArgumentException {
        Iterator it = this.myRefactoringSchemes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!this.checkUniqueness((IMember)next.getKey(), (String)next.getValue())) {
                this.setFailed();
                return;
            }
            if (this.checkValidName((IMember)next.getKey(), (String)next.getValue())) continue;
            this.setFailed();
            return;
        }
        Iterator it2 = this.myRefactoringSchemes.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            IMember key = (IMember)next.getKey();
            String newName = (String)next.getValue();
            this.createOccurrences(key, newName);
            if (!this.failed()) continue;
            return;
        }
    }

    private boolean checkUniqueness(IMember member, String newName) {
        switch (member.getElementType()) {
            case 7: {
                return JDTUtils.findType(member.getJavaProject(), ((IType)member).getPackageFragment().getElementName(), newName) == null;
            }
            case 8: {
                return !member.getDeclaringType().getField(newName).exists();
            }
            case 9: {
                IMethod method = (IMethod)member;
                IType type = method.getDeclaringType();
                IMethod[] foundMethods = type.findMethods(type.getMethod(newName, method.getParameterTypes()));
                return foundMethods == null || foundMethods.length == 0;
            }
        }
        return false;
    }

    private boolean checkValidName(IMember member, String name) {
        switch (member.getElementType()) {
            case 7: {
                return JavaConventions.validateJavaTypeName((String)name).isOK() && JavaConventions.validateCompilationUnitName((String)(name + ".java")).isOK();
            }
            case 8: {
                return JavaConventions.validateFieldName((String)name).isOK() && Character.isLowerCase(name.charAt(0));
            }
            case 9: {
                return JavaConventions.validateMethodName((String)name).isOK();
            }
        }
        return false;
    }

    private void createOccurrences(IMember member, String newName) {
        this.createJavaSearchOccurrences(member, newName);
        if (this.failed()) {
            return;
        }
        if (member.getElementType() == 7) {
            this.createCommentTextOccurrences((IType)member, newName);
        }
    }

    private void createJavaSearchOccurrences(IMember member, String newName) {
        try {
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), (IJavaElement)member, this.getDefaultLimit(member), this.getScope(member), (IJavaSearchResultCollector)new JavaSearchCollector(this, member, newName));
        }
        catch (JavaModelException e) {
            this.setFailed();
        }
    }

    private void createCommentTextOccurrences(IType type, String newName) {
        try {
            String pattern = START + type.getFullyQualifiedName() + END;
            String newFQN = type.getPackageFragment().getElementName().length() == 0 ? START + newName + END : START + type.getPackageFragment().getElementName() + '.' + newName + END;
            String options = "";
            new TextSearchEngine().search(ResourcesPlugin.getWorkspace(), pattern, options, (ISearchScope)new JavaFilesSearchScope(type.getJavaProject().getProject()), (ITextSearchResultCollector)new TextSearchCollector(this, null, newFQN));
        }
        catch (Exception e) {
            this.setFailed();
        }
    }

    private IJavaSearchScope getScope(IMember member) {
        IJavaProject project = member.getJavaProject();
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)true);
    }

    private int getDefaultLimit(IMember member) {
        if (member.getElementType() == 9 && this.isConstructor((IMethod)member)) {
            return 0;
        }
        return this.myLimit;
    }

    private boolean isConstructor(IMethod method) {
        return method.getElementName().equals(method.getDeclaringType().getElementName());
    }

    public final void setDefaultLimit(int limit) {
        this.myLimit = limit;
    }
}

