/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceProducer;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.JavaOccurrenceImpl;
import com.tssap.j2ee.core.utils.refactoring.TextResourceOccurrencesImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;

public class JavaSearchCollector
implements IJavaSearchResultCollector {
    private String myNewName;
    private String myNewFQN;
    private IResourceOccurrenceProducer myProducer;
    private IMember myMember;
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final IResourceOccurrenceCreator CREATOR = new IResourceOccurrenceCreator(){

        public IResourceOccurrences createResourceOccurrence(IFile resource) {
            return new TextResourceOccurrencesImpl(resource);
        }
    };

    public JavaSearchCollector(IResourceOccurrenceProducer producer, IMember member, String newName) {
        this.myNewName = newName;
        this.myProducer = producer;
        this.myMember = member;
        this.myNewFQN = this.myMember.getElementType() == 7 ? this.getFQN(((IType)member).getPackageFragment().getElementName(), this.myNewName) : null;
    }

    private String getFQN(String packageName, String typeName) {
        if (packageName.length() == 0) {
            return this.myNewName;
        }
        return packageName + '.' + typeName;
    }

    public void aboutToStart() {
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        if (accuracy != 0) {
            return;
        }
        if (resource == null || resource.getType() != 1) {
            return;
        }
        try {
            IFile file = (IFile)resource;
            IResourceOccurrences occurrences = this.myProducer.getOccurrences(file, CREATOR);
            occurrences.addOccurrence(this.createJavaOccurrence(file, start, end, enclosingElement, this.myNewName, this.myNewFQN));
        }
        catch (IllegalArgumentException e) {
            this.myProducer.setFailed();
        }
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return NULL_MONITOR;
    }

    private IOccurrence createJavaOccurrence(IFile file, int start, int end, IJavaElement enclosingElement, String newName, String newFQN) {
        return new JavaOccurrenceImpl(file, this.myMember, enclosingElement, start, end, newName, newFQN);
    }
}

