/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.search.internal.core.ISearchScope;

public class JavaFilesSearchScope
implements ISearchScope {
    private IProject myProject;
    private Collection myDependenctProjects;

    public JavaFilesSearchScope(IProject originalProject) {
        this.myProject = originalProject;
        this.myDependenctProjects = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(this.myProject);
    }

    public boolean encloses(IResource element) {
        if (element.getType() != 1 || !"java".equals(element.getFileExtension())) {
            return false;
        }
        IProject elementProject = element.getProject();
        return this.projectMatches(elementProject);
    }

    private boolean projectMatches(IProject elementProject) {
        return elementProject.equals((Object)this.myProject) || this.myDependenctProjects.contains(elementProject);
    }

    public boolean encloses(IResourceProxy element) {
        if (element.getType() != 1 || !element.getName().endsWith(".java")) {
            return false;
        }
        IPath elementPath = element.requestFullPath();
        String projectName = elementPath.segment(0);
        IProject elementProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return this.projectMatches(elementProject);
    }

    public String getDescription() {
        return "All java compilation units";
    }
}

