/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractResourceOccurrences
implements IResourceOccurrences {
    private IFile myFile;
    private long myStamp;
    private boolean myHasPerformed;

    public AbstractResourceOccurrences(IFile file) {
        this.myFile = file;
        this.myStamp = this.getModificationStamp(this.myFile);
    }

    protected void preAddOccurrence(IOccurrence occurrence, Class expectedClass) {
        this.preAddOccurrence(occurrence, expectedClass, false);
    }

    protected void preAddOccurrence(IOccurrence occurrence, Class expectedClass, boolean allowNullFile) {
        if (occurrence == null) {
            throw new IllegalArgumentException();
        }
        if (!(allowNullFile || occurrence.getResource() != null && this.getFile().equals((Object)occurrence.getResource()))) {
            throw new IllegalArgumentException();
        }
        if (this.getModificationStamp(this.myFile) != this.myStamp) {
            throw new IllegalArgumentException("Resource has been changed");
        }
        if (this.myHasPerformed) {
            throw new IllegalArgumentException("Changes have already been performed");
        }
        if (expectedClass != null && !expectedClass.isInstance(occurrence)) {
            throw new IllegalArgumentException(occurrence.getClass().getName());
        }
    }

    private long getModificationStamp(IFile resource) {
        if (resource == null) {
            return -1L;
        }
        return resource.getModificationStamp();
    }

    public boolean canPerformNaive() {
        return !this.hasPerformed() && this.checkNotChanged() && this.myFile.exists();
    }

    public boolean canPerform() {
        if (!this.canPerformNaive()) {
            return false;
        }
        return !this.myFile.isReadOnly();
    }

    public final boolean hasPerformed() {
        return this.myHasPerformed;
    }

    public final void performed() {
        this.myHasPerformed = true;
    }

    public IFile getFile() {
        return this.myFile;
    }

    protected CoreException newCoreException(String msg, Throwable e) {
        return new CoreException((IStatus)new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, msg, e));
    }

    private boolean checkNotChanged() {
        return this.getModificationStamp(this.myFile) == this.myStamp;
    }

    public boolean isMoveOccurrence() {
        return false;
    }

    public abstract void undo(IProgressMonitor var1) throws CoreException;

    public abstract void perform(IProgressMonitor var1) throws CoreException;

    public abstract IOccurrence[] getAllOccurrences();

    public abstract void addOccurrence(IOccurrence var1);
}

