/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.refactoring;

import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceProducer;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractChangePerformer
implements IResourceOccurrenceProducer {
    private HashMap myResources2ResourceOccurrences = new HashMap();
    private Boolean myFailureStatus;

    public final boolean canPerformNaive() {
        this.createResourceOccurrences();
        if (this.failed()) {
            return false;
        }
        Iterator it = this.myResources2ResourceOccurrences.values().iterator();
        while (it.hasNext()) {
            IResourceOccurrences next = (IResourceOccurrences)it.next();
            if (next.canPerformNaive()) continue;
            return false;
        }
        return true;
    }

    public final boolean canPerform() {
        this.createResourceOccurrences();
        if (this.failed()) {
            return false;
        }
        ReadOnlinessValidator roValidator = new ReadOnlinessValidator();
        Iterator it = this.myResources2ResourceOccurrences.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            roValidator.addResource((IFile)next.getKey());
        }
        if (!roValidator.canModify()) {
            return false;
        }
        Iterator it2 = this.myResources2ResourceOccurrences.values().iterator();
        while (it2.hasNext()) {
            IResourceOccurrences next = (IResourceOccurrences)it2.next();
            if (next.canPerform()) continue;
            return false;
        }
        return true;
    }

    public final void perform(IProgressMonitor m) throws CoreException {
        if (!this.canPerform()) {
            throw new CoreException((IStatus)new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Cannot perform", null));
        }
        if (m == null) {
            m = new NullProgressMonitor();
        }
        m.beginTask("Performing change", this.myResources2ResourceOccurrences.size());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<IResourceOccurrences> processedChanges = new ArrayList<IResourceOccurrences>();
                try {
                    try {
                        Iterator it = AbstractChangePerformer.this.myResources2ResourceOccurrences.values().iterator();
                        while (it.hasNext()) {
                            IResourceOccurrences next = (IResourceOccurrences)it.next();
                            processedChanges.add(next);
                            next.perform((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        AbstractChangePerformer.this.performed();
                    }
                    catch (CoreException e) {
                        AbstractChangePerformer.this.undoProcessedChanges(processedChanges, (IProgressMonitor)new SubProgressMonitor(monitor, AbstractChangePerformer.this.myResources2ResourceOccurrences.size() - processedChanges.size()));
                        throw e;
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        }, m);
    }

    protected abstract void performed();

    private void undoProcessedChanges(Collection processedChanges, IProgressMonitor monitor) {
        monitor.beginTask("Undoing processed changes", processedChanges.size());
        Iterator it = processedChanges.iterator();
        while (it.hasNext()) {
            IResourceOccurrences next = (IResourceOccurrences)it.next();
            try {
                if (next.hasPerformed()) {
                    next.undo((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                monitor.worked(1);
            }
            catch (CoreException e) {
                UtilsPlugin.logError("Exception occurred while undoing changes", e);
            }
        }
    }

    public final void createResourceOccurrences() {
        if (this.myFailureStatus != null) {
            return;
        }
        try {
            this.doCreateResourceOccurrences();
            if (this.myFailureStatus == null) {
                this.myFailureStatus = Boolean.FALSE;
            }
        }
        catch (IllegalArgumentException e) {
            UtilsPlugin.logError("Exception occurred while collecting references", e);
            this.setFailed();
        }
    }

    protected abstract void doCreateResourceOccurrences() throws IllegalArgumentException;

    public final void setFailed() {
        this.myFailureStatus = Boolean.TRUE;
    }

    public final boolean failed() {
        return Boolean.TRUE.equals(this.myFailureStatus);
    }

    public final IResourceOccurrences getOccurrences(IFile resource, IResourceOccurrenceCreator creator) {
        IResourceOccurrences result = (IResourceOccurrences)this.myResources2ResourceOccurrences.get(resource);
        if (result == null) {
            result = creator.createResourceOccurrence(resource);
            this.myResources2ResourceOccurrences.put(resource, result);
        }
        return result;
    }

    public Map getResourceOccurrences() {
        return Collections.unmodifiableMap(this.myResources2ResourceOccurrences);
    }

    protected void putResourceOccurrences(IFile resource, IResourceOccurrences occ) {
        this.myResources2ResourceOccurrences.put(resource, occ);
    }
}

