/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.internal.core.ejb.util.JavaCommentParserFactory;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import java.util.Enumeration;
import org.eclipse.jdt.core.IMember;

public class StringDdpAccessor
implements DdpDescriptor.Accessor {
    public static final String AT = "@";

    public Object read(Object source, DdpDescriptor descriptor) {
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return null;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return null;
        }
        Enumeration comments = comment.getTags(tagName);
        if (!comments.hasMoreElements()) {
            return null;
        }
        ITag tag = (ITag)comments.nextElement();
        if (comments.hasMoreElements()) {
            return null;
        }
        return tag.getValue();
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return false;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return false;
        }
        Enumeration comments = comment.getTags(tagName);
        if (comments.hasMoreElements()) {
            comments.nextElement();
            if (comments.hasMoreElements()) {
                return false;
            }
        }
        return true;
    }

    public void write(Object source, Object value, DdpDescriptor descriptor) {
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return;
        }
        if (!this.edit(source)) {
            return;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return;
        }
        String tagValue = this.getTagValue(value, descriptor);
        Enumeration comments = comment.getTags(tagName);
        if (!comments.hasMoreElements()) {
            comment.addTag(tagName, tagValue);
        } else {
            ITag tag = (ITag)comments.nextElement();
            if (comments.hasMoreElements()) {
                return;
            }
            tag.setValue(tagValue);
        }
        comment.synchronize(true);
    }

    protected IJavaComment getComment(Object source) {
        if (!(source instanceof IMember)) {
            return null;
        }
        IMember member = (IMember)source;
        return JavaCommentParserFactory.getJavaComment(member);
    }

    protected String getTagName(DdpDescriptor descriptor) {
        String tagName = descriptor.getAccessorData();
        if (tagName == null || tagName.trim().length() == 0) {
            tagName = descriptor.getPropertyName();
        }
        return AT + tagName;
    }

    protected String getTagValue(Object value, DdpDescriptor descriptor) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected boolean edit(Object source) {
        if (!(source instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)source;
        ReadOnlinessValidator v = new ReadOnlinessValidator();
        v.addJavaElement(member);
        return v.canModify();
    }
}

