/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.utils.ddp.javadoc.StringDdpAccessor;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

public class MultiStringDdpAccessor
extends StringDdpAccessor {
    public Object read(Object source, DdpDescriptor descriptor) {
        String defTagName;
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return null;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return null;
        }
        StringArrayList values = null;
        Enumeration comments = comment.getTags(tagName);
        while (comments.hasMoreElements()) {
            String value = ((ITag)comments.nextElement()).getValue();
            if (value == null || value.trim().length() == 0) continue;
            if (values == null) {
                values = new StringArrayList();
            }
            values.add(value);
        }
        if (values == null && (defTagName = this.getDefaultTagName(descriptor)) != null && (comments = comment.getTags(defTagName)).hasMoreElements()) {
            values = new StringArrayList();
        }
        return values;
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return false;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return false;
        }
        return this.isValidValue(value);
    }

    public void write(Object source, Object value, DdpDescriptor descriptor) {
        StringArrayList tagValue;
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return;
        }
        if (!this.edit(source)) {
            return;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return;
        }
        Enumeration comments = comment.getTags(tagName);
        while (comments.hasMoreElements()) {
            ((ITag)comments.nextElement()).setValue(null);
        }
        String defTagName = this.getDefaultTagName(descriptor);
        if (defTagName != null) {
            comments = comment.getTags(defTagName);
            while (comments.hasMoreElements()) {
                ((ITag)comments.nextElement()).setValue(null);
            }
        }
        if ((tagValue = this.getValidValue(value)) != null) {
            if (tagValue.isEmpty() && defTagName != null) {
                comment.addTag(defTagName, "");
            } else {
                int i = 0;
                while (i < tagValue.size()) {
                    comment.addTag(tagName, tagValue.getString(i));
                    ++i;
                }
            }
        }
        comment.synchronize(true);
    }

    protected boolean isValidValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof StringArrayList) {
            return true;
        }
        if (value instanceof List) {
            try {
                new StringArrayList((Collection)((List)value));
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        return false;
    }

    protected StringArrayList getValidValue(Object value) {
        if (value instanceof String) {
            StringArrayList list = new StringArrayList((String)value);
            return list.isEmpty() ? null : list;
        }
        if (value instanceof StringArrayList) {
            return (StringArrayList)value;
        }
        if (value instanceof List) {
            try {
                return new StringArrayList((Collection)((List)value));
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        return null;
    }

    protected String getTagName(DdpDescriptor descriptor) {
        String tagName = super.getTagName(descriptor);
        int i = tagName.indexOf(44);
        if (i >= 0) {
            tagName = tagName.substring(0, i).trim();
        }
        return tagName;
    }

    protected String getDefaultTagName(DdpDescriptor descriptor) {
        String tagName = super.getTagName(descriptor);
        int i = tagName.indexOf(44);
        if (i < 0) {
            return null;
        }
        if ((tagName = tagName.substring(i + 1).trim()).length() == 0) {
            return null;
        }
        return "@" + tagName;
    }
}

