/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.utils.ddp.javadoc.StringDdpAccessor;

public class IntegerDdpAccessor
extends StringDdpAccessor {
    public Object read(Object source, DdpDescriptor descriptor) {
        return this.getValidValue((String)super.read(source, descriptor));
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        if (!this.isValidValue(value = IntegerDdpAccessor.trim(value))) {
            return false;
        }
        return super.canWrite(source, value, descriptor);
    }

    public void write(Object source, Object value, DdpDescriptor descriptor) {
        if (!this.isValidValue(value = IntegerDdpAccessor.trim(value))) {
            return;
        }
        super.write(source, value, descriptor);
    }

    protected Object getValidValue(String value) {
        if ((value = (String)IntegerDdpAccessor.trim(value)) == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected boolean isValidValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof String) {
            try {
                Integer.parseInt((String)value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    protected static Object trim(Object o) {
        if (!(o instanceof String)) {
            return o;
        }
        String s = ((String)o).trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }
}

