/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.StringUtils;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.utils.ddp.javadoc.StringDdpAccessor;

public class DescribedStringDdpAccessor
extends StringDdpAccessor {
    public Object read(Object source, DdpDescriptor descriptor) {
        String value = (String)super.read(source, descriptor);
        if (value == null) {
            return null;
        }
        StringArrayList salValue = StringArrayList.getValuesAsList(value, " ", 1);
        if (!salValue.isEmpty()) {
            salValue.set(0, StringUtils.unescape(salValue.getString(0)));
        }
        return salValue;
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        if (!super.canWrite(source, value, descriptor)) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (value instanceof StringArrayList) {
            StringArrayList salValue = (StringArrayList)value;
            if (salValue.isEmpty()) {
                return false;
            }
            String sValue = salValue.getString(0);
            if (sValue == null || sValue.trim().length() == 0) {
                return false;
            }
            return salValue.size() <= 2;
        }
        return false;
    }

    protected String getTagValue(Object value, DdpDescriptor descriptor) {
        if (value instanceof StringArrayList) {
            StringArrayList salValue = (StringArrayList)value;
            if (salValue.isEmpty()) {
                return null;
            }
            salValue.set(0, StringUtils.escape(salValue.getString(0)));
            return salValue.toString(" ");
        }
        return null;
    }
}

