/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.StringUtils;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.utils.ddp.javadoc.MultiStringDdpAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DescribedMultiStringDdpAccessor
extends MultiStringDdpAccessor {
    public Object read(Object source, DdpDescriptor descriptor) {
        StringArrayList rawValue = (StringArrayList)super.read(source, descriptor);
        if (rawValue == null) {
            return null;
        }
        if (rawValue.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StringArrayList> value = new ArrayList<StringArrayList>(rawValue.size());
        int i = 0;
        while (i < rawValue.size()) {
            String rawItem = rawValue.getString(i);
            StringArrayList item = StringArrayList.getValuesAsList(rawItem, " ", 1);
            if (item != null && !item.isEmpty()) {
                item.set(0, StringUtils.unescape(item.getString(0)));
                value.add(item);
            }
            ++i;
        }
        return value;
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        List lValue;
        if (value == null) {
            lValue = null;
        } else if (value instanceof List) {
            lValue = (List)value;
        } else {
            return false;
        }
        return super.canWrite(source, this.escape(lValue), descriptor);
    }

    public void write(Object source, Object value, DdpDescriptor descriptor) {
        List lValue;
        if (value == null) {
            lValue = null;
        } else if (value instanceof List) {
            lValue = (List)value;
        } else {
            throw new IllegalArgumentException();
        }
        super.write(source, this.escape(lValue), descriptor);
    }

    protected StringArrayList escape(List value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return StringArrayList.EMPTY_LIST;
        }
        StringArrayList rawValue = new StringArrayList(value.size());
        int i = 0;
        while (i < value.size()) {
            StringArrayList item;
            Object itemObj = value.get(i);
            if (itemObj instanceof StringArrayList && !(item = (StringArrayList)itemObj).isEmpty()) {
                String item0 = item.getString(0);
                item.set(0, StringUtils.escape(item0));
                rawValue.add(item.toString(" "));
                item.set(0, item0);
            }
            ++i;
        }
        return rawValue;
    }
}

