/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp.javadoc;

import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.utils.ddp.javadoc.StringDdpAccessor;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import java.util.Enumeration;

public class BooleanDdpAccessor
extends StringDdpAccessor {
    public Object read(Object source, DdpDescriptor descriptor) {
        return this.getValidValue((String)super.read(source, descriptor));
    }

    public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
        if (!this.isValidValue(value = BooleanDdpAccessor.trim(value))) {
            return false;
        }
        return super.canWrite(source, value, descriptor);
    }

    public void write(Object source, Object value, DdpDescriptor descriptor) {
        if (!this.isValidValue(value = BooleanDdpAccessor.trim(value))) {
            return;
        }
        IJavaComment comment = this.getComment(source);
        if (comment == null) {
            return;
        }
        if (!this.edit(source)) {
            return;
        }
        String tagName = this.getTagName(descriptor);
        if (tagName == null) {
            return;
        }
        boolean bValue = this.getBooleanValue(value);
        Enumeration comments = comment.getTags(tagName);
        if (!comments.hasMoreElements()) {
            if (bValue) {
                comment.addTag(tagName, "");
            }
        } else {
            ITag tag = (ITag)comments.nextElement();
            if (comments.hasMoreElements()) {
                return;
            }
            tag.setValue(bValue ? "" : null);
        }
        comment.synchronize(true);
    }

    protected boolean getBooleanValue(Object value) {
        boolean bValue = false;
        if (value instanceof Boolean) {
            bValue = (Boolean)value;
        } else if (value instanceof String) {
            bValue = Boolean.valueOf((String)BooleanDdpAccessor.trim(value));
        }
        return bValue;
    }

    protected Object getValidValue(String value) {
        return new Boolean(value != null);
    }

    protected boolean isValidValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        return value instanceof String;
    }

    protected static Object trim(Object o) {
        if (!(o instanceof String)) {
            return o;
        }
        String s = ((String)o).trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }
}

