/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.utils.ddp.DdpAccessorFactory;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;

public class DdpRegistry {
    public static final String DDP_EXT_POINT = "ddpRegistry";
    public static final String DDP_TAG = "ddp";
    public static final String DDP_AF_EXT_POINT = "ddpAccessorFactory";
    public static final String DDP_AF_TAG = "factory";
    public static final String DDP_AF_CLASS_ATTR = "class";
    private static Map ourDescriptors;
    private static List ourAccessorFactories;

    private DdpRegistry() {
    }

    private static void readDescriptors() {
        ourDescriptors = new HashMap();
        IExtensionPoint ep = UtilsPlugin.getDefault().getDescriptor().getExtensionPoint(DDP_EXT_POINT);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] ces = ep.getConfigurationElements();
        if (ces == null || ces.length == 0) {
            return;
        }
        int i = 0;
        while (i < ces.length) {
            IConfigurationElement ce = ces[i];
            if (DDP_TAG.equals(ce.getName())) {
                DdpDescriptor d = new DdpDescriptor(ce);
                if (!d.isValid()) {
                    UtilsPlugin.logWarning("Invalid default deployment property descriptor " + d);
                } else {
                    StringArrayList keys = d.getKeys();
                    int j = keys.size() - 1;
                    while (j >= 0) {
                        DdpRegistry.addDescriptor(d, keys.getString(j));
                        --j;
                    }
                }
            }
            ++i;
        }
    }

    private static void addDescriptor(DdpDescriptor d, String key) {
        Object value = ourDescriptors.get(key);
        if (value == null) {
            ourDescriptors.put(key, d);
        } else if (value instanceof DdpDescriptor) {
            if (((DdpDescriptor)value).getPropertyName().equals(d.getPropertyName())) {
                UtilsPlugin.logWarning("Default deployment property descriptor for the property " + d.getPropertyName() + " already bound");
                return;
            }
            ArrayList<Object> ds = new ArrayList<Object>();
            ds.add(value);
            ds.add(d);
            ourDescriptors.put(key, ds);
        } else if (value instanceof List) {
            List ds = (List)value;
            int j = ds.size() - 1;
            while (j >= 0) {
                DdpDescriptor dj = (DdpDescriptor)ds.get(j);
                if (dj.getPropertyName().equals(d.getPropertyName())) {
                    UtilsPlugin.logWarning("Default deployment property descriptor for the property " + d.getPropertyName() + " already bound");
                    return;
                }
                --j;
            }
            ds.add(d);
        } else {
            throw new IllegalStateException();
        }
        UtilsPlugin.logInfo("Default deployment property descriptor added " + d);
    }

    private static void readAccessorFactories() {
        ourAccessorFactories = new ArrayList();
        IExtensionPoint ep = UtilsPlugin.getDefault().getDescriptor().getExtensionPoint(DDP_AF_EXT_POINT);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] ces = ep.getConfigurationElements();
        if (ces == null || ces.length == 0) {
            return;
        }
        int i = 0;
        while (i < ces.length) {
            IConfigurationElement ce = ces[i];
            if (DDP_AF_TAG.equals(ce.getName())) {
                try {
                    DdpAccessorFactory af = (DdpAccessorFactory)ce.createExecutableExtension(DDP_AF_CLASS_ATTR);
                    ourAccessorFactories.add(af);
                    UtilsPlugin.logInfo("Ddp accessor factory added " + af);
                }
                catch (Exception e) {
                    UtilsPlugin.logWarning("Unable to create ddp accessor facrory " + e);
                }
            }
            ++i;
        }
    }

    public static String[] getPropertyNames(String key) {
        Object value;
        if (ourDescriptors == null) {
            DdpRegistry.readDescriptors();
        }
        if ((value = ourDescriptors.get(key)) == null) {
            return null;
        }
        if (value instanceof List) {
            List ds = (List)value;
            String[] names = new String[ds.size()];
            int i = ds.size() - 1;
            while (i >= 0) {
                names[i] = ((DdpDescriptor)ds.get(i)).getPropertyName();
                --i;
            }
            return names;
        }
        if (value instanceof DdpDescriptor) {
            return new String[]{((DdpDescriptor)value).getPropertyName()};
        }
        throw new IllegalStateException();
    }

    public static DdpDescriptor getDescriptor(String key, String propertyName) {
        Object value;
        if (propertyName == null) {
            throw new NullPointerException();
        }
        if (ourDescriptors == null) {
            DdpRegistry.readDescriptors();
        }
        if ((value = ourDescriptors.get(key)) == null) {
            return null;
        }
        if (value instanceof List) {
            List ds = (List)value;
            int i = ds.size() - 1;
            while (i >= 0) {
                DdpDescriptor d = (DdpDescriptor)ds.get(i);
                if (d.getPropertyName().equals(propertyName)) {
                    return d;
                }
                --i;
            }
            return null;
        }
        if (value instanceof DdpDescriptor) {
            DdpDescriptor d = (DdpDescriptor)value;
            if (d.getPropertyName().equals(propertyName)) {
                return d;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public static DdpDescriptor[] getDescriptors(String key) {
        Object value;
        if (ourDescriptors == null) {
            DdpRegistry.readDescriptors();
        }
        if ((value = ourDescriptors.get(key)) == null) {
            return null;
        }
        if (value instanceof List) {
            List ds = (List)value;
            return ds.toArray(new DdpDescriptor[ds.size()]);
        }
        if (value instanceof DdpDescriptor) {
            return new DdpDescriptor[]{(DdpDescriptor)value};
        }
        throw new IllegalStateException();
    }

    public static DdpDescriptor.Accessor getAccessor(Object source, String type) {
        if (ourAccessorFactories == null) {
            DdpRegistry.readAccessorFactories();
        }
        int i = ourAccessorFactories.size() - 1;
        while (i >= 0) {
            DdpAccessorFactory factory = (DdpAccessorFactory)ourAccessorFactories.get(i);
            DdpDescriptor.Accessor accessor = factory.getAccessor(source, type);
            if (accessor != null) {
                return accessor;
            }
            --i;
        }
        UtilsPlugin.logWarning("Ddp accessor [" + type + "] not found for the " + source);
        return null;
    }
}

