/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.ddp.DdpRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class DdpDescriptor {
    public static final String KEY_TAG = "key";
    public static final String KEYS_TAG = "keys";
    public static final String PROPERTY_NAME_TAG = "property";
    public static final String ACCESSOR_TAG = "accessor";
    public static final String ACCESSOR_DATA_TAG = "accessorData";
    public static final String EXECUTIVE_TAG = "executive";
    public static final String EXECUTIVE_DATA_TAG = "executiveData";
    private IConfigurationElement myConfigurationElement;
    private Executive myExecutive = NULL_EXECUTIVE;
    private boolean myExecutiveInvalid;
    private StringArrayList myKeys;
    private String myPropertyName;
    private String myAccessorData;
    private String myExecutiveData;
    private String myAccessorType;
    public static final Accessor NULL_ACCESSOR = new Accessor(){

        public Object read(Object source, DdpDescriptor descriptor) {
            return null;
        }

        public boolean canWrite(Object source, Object value, DdpDescriptor descriptor) {
            return false;
        }

        public void write(Object source, Object value, DdpDescriptor descriptor) {
        }
    };
    public static final Executive NULL_EXECUTIVE = new Executive(){

        public void apply(Object entity, Object value, DdpDescriptor descriptor) {
        }
    };

    public DdpDescriptor(IConfigurationElement element) {
        String key;
        this.myConfigurationElement = element;
        if (this.myConfigurationElement == null) {
            return;
        }
        String keys = this.myConfigurationElement.getAttribute(KEYS_TAG);
        if (keys != null) {
            this.myKeys = new StringArrayList(keys);
        }
        if ((key = this.myConfigurationElement.getAttribute(KEY_TAG)) != null) {
            if (this.myKeys == null) {
                this.myKeys = new StringArrayList();
            }
            this.myKeys.add(key);
        }
        if (this.myKeys != null) {
            this.myKeys = new StringArrayList.Unmodifiable(this.myKeys);
        }
        this.myPropertyName = this.myConfigurationElement.getAttribute(PROPERTY_NAME_TAG);
        this.myAccessorData = this.myConfigurationElement.getAttribute(ACCESSOR_DATA_TAG);
        this.myExecutiveData = this.myConfigurationElement.getAttribute(EXECUTIVE_DATA_TAG);
        this.myAccessorType = this.myConfigurationElement.getAttribute(ACCESSOR_TAG);
    }

    public boolean isValid() {
        if (this.myConfigurationElement == null) {
            return false;
        }
        StringArrayList keys = this.getKeys();
        if (keys == null || keys.isEmpty()) {
            return false;
        }
        if (DdpDescriptor.isNull(this.getPropertyName())) {
            return false;
        }
        this.createExecutive();
        return !this.myExecutiveInvalid;
    }

    public StringArrayList getKeys() {
        return this.myKeys;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public Object getPropertyValue(Object source) {
        Accessor accessor = this.getAccessor(source);
        if (accessor == null) {
            return null;
        }
        return accessor.read(source, this);
    }

    public boolean canSetPropertyValue(Object source, Object value) {
        Accessor accessor = this.getAccessor(source);
        if (accessor == null) {
            return false;
        }
        return accessor.canWrite(source, value, this);
    }

    public void setPropertyValue(Object source, Object value) {
        Accessor accessor = this.getAccessor(source);
        if (accessor == null) {
            return;
        }
        accessor.write(source, value, this);
    }

    public void apply(Object entity, Object value) {
        if (this.myExecutive == null) {
            return;
        }
        this.myExecutive.apply(entity, value, this);
    }

    public String getAccessorData() {
        return this.myAccessorData;
    }

    public String getExecutiveData() {
        return this.myExecutiveData;
    }

    private Accessor getAccessor(Object source) {
        if (this.myConfigurationElement == null) {
            return null;
        }
        if (DdpDescriptor.isNull(this.myAccessorType)) {
            return null;
        }
        return DdpRegistry.getAccessor(source, this.myAccessorType);
    }

    private void createExecutive() {
        if (this.myExecutive != NULL_EXECUTIVE) {
            return;
        }
        this.myExecutive = null;
        if (this.myConfigurationElement == null) {
            return;
        }
        String executiveClassName = this.myConfigurationElement.getAttribute(EXECUTIVE_TAG);
        if (!DdpDescriptor.isNull(executiveClassName)) {
            this.myExecutiveInvalid = true;
            try {
                this.myExecutive = (Executive)this.myConfigurationElement.createExecutableExtension(EXECUTIVE_TAG);
                this.myExecutiveInvalid = false;
            }
            catch (CoreException ce) {
                this.myExecutiveInvalid = true;
            }
            catch (ClassCastException cce) {
                this.myExecutiveInvalid = true;
            }
        }
    }

    private static boolean isNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("DDP [");
        if (this.myConfigurationElement != null) {
            buffer.append("property: ");
            buffer.append(this.getPropertyName());
            buffer.append(", keys: ");
            buffer.append(this.getKeys());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static interface Executive {
        public void apply(Object var1, Object var2, DdpDescriptor var3);
    }

    public static interface Accessor {
        public Object read(Object var1, DdpDescriptor var2);

        public boolean canWrite(Object var1, Object var2, DdpDescriptor var3);

        public void write(Object var1, Object var2, DdpDescriptor var3);
    }
}

