/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp;

import com.tssap.j2ee.core.utils.ddp.DdpElement;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractObjectDdpProvider
extends AbstractProvider
implements ObjectPropertyProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return this.getPropertyNames(element).contains(propertyName);
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return null;
        }
        return ddpElement.getDdp(propertyName);
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Set propertyNames = this.getPropertyNames(element);
        ArrayList<Object> propertyValues = new ArrayList<Object>(propertyNames.size());
        Iterator propertyNamesIterator = propertyNames.iterator();
        while (propertyNamesIterator.hasNext()) {
            Object value = this.getObjectPropertyValue(element, (String)propertyNamesIterator.next());
            if (value == null) continue;
            propertyValues.add(value);
        }
        return Collections.enumeration(propertyValues);
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return false;
        }
        return ddpElement.canSetDdp(propertyName, propertyValue);
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return;
        }
        ddpElement.setDdp(propertyName, propertyValue);
    }

    protected Set getPropertyNames(Element element) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return Collections.EMPTY_SET;
        }
        String[] names = ddpElement.getDdpNames();
        if (names == null || names.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> namesSet = new HashSet<String>(names.length * 2);
        int i = 0;
        while (i < names.length) {
            namesSet.add(names[i]);
            ++i;
        }
        return namesSet;
    }

    protected abstract DdpElement getDdpElement(Element var1);
}

