/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.ddp;

import com.tssap.j2ee.core.utils.ddp.DdpElement;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractPropertyWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractDdpProvider
extends AbstractPropertyWriter {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return this.getPropertyNames(element).contains(propertyName);
    }

    public boolean hasProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        return propertyValue != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return this.getProperty(element, propertyName, propertyValue);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        return property == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public PropertyEnumeration properties(Element element) {
        Set propertyNames = this.getPropertyNames(element);
        ArrayList<Property> properties = new ArrayList<Property>(propertyNames.size());
        Iterator propertyNamesIterator = propertyNames.iterator();
        while (propertyNamesIterator.hasNext()) {
            Property property = this.getProperty(element, (String)propertyNamesIterator.next());
            if (property == null) continue;
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    public String getPropertyValue(Element element, String propertyName) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return null;
        }
        Object value = ddpElement.getDdp(propertyName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return false;
        }
        return ddpElement.canSetDdp(propertyName, propertyValue);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return;
        }
        ddpElement.setDdp(propertyName, propertyValue);
    }

    protected Set getPropertyNames() {
        return Collections.EMPTY_SET;
    }

    protected Set getPropertyNames(Element element) {
        DdpElement ddpElement = this.getDdpElement(element);
        if (ddpElement == null) {
            return Collections.EMPTY_SET;
        }
        String[] names = ddpElement.getDdpNames();
        if (names == null || names.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> namesSet = new HashSet<String>(names.length * 2);
        int i = 0;
        while (i < names.length) {
            namesSet.add(names[i]);
            ++i;
        }
        return namesSet;
    }

    protected abstract DdpElement getDdpElement(Element var1);
}

