/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.clipboard;

import com.tssap.j2ee.core.utils.clipboard.ClipboardElement;
import com.tssap.j2ee.core.utils.clipboard.ModelClipboard;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.PasteProvider;
import com.tssap.selena.model.util.extension.AbstractProvider;

public final class GenericPasteProvider
extends AbstractProvider
implements PasteProvider {
    public boolean isPasteProviderApplicable(Entity container) {
        return Boolean.valueOf(container.getPropertyValue("$enableGenericPaste"));
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        UniqueName uin = element.getUniqueName();
        if (!(uin instanceof CopyUniqueName)) {
            return false;
        }
        ClipboardElement clipboardElement = ModelClipboard.getElement((CopyUniqueName)uin);
        if (clipboardElement == null) {
            return false;
        }
        Model model = clipboardElement.getModel();
        if (model == null || !model.getUniqueName().equals(this.getModel().getUniqueName())) {
            return false;
        }
        Entity template = this.getModel().createEntityTemplate();
        template.setObjectPropertyValue("$elementToClone", (Object)clipboardElement);
        template.setObjectPropertyValue("$anchorElement", (Object)anchor);
        template.setPropertyValue("$beforeAnchor", String.valueOf(before));
        String shapeType = clipboardElement.getPropertyValue("$metaclass");
        return container.canCreateChildEntity(shapeType, template);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        ClipboardElement clipboardElement = ModelClipboard.getElement((CopyUniqueName)element.getUniqueName());
        Entity result = this.pasteHelper(container, clipboardElement, anchor, before);
        if (result == null) {
            return null;
        }
        return result.getUniqueName();
    }

    protected Entity pasteHelper(Entity container, ClipboardElement clipboardElement, Element anchor, boolean before) {
        EntityEnumeration children;
        if (clipboardElement == null) {
            return null;
        }
        if (clipboardElement.isCut()) {
            clipboardElement.setCut(false);
        }
        Entity template = this.getModel().createEntityTemplate();
        template.setObjectPropertyValue("$elementToClone", (Object)clipboardElement);
        template.setObjectPropertyValue("$anchorElement", (Object)anchor);
        template.setPropertyValue("$beforeAnchor", String.valueOf(before));
        String shapeType = clipboardElement.getPropertyValue("$metaclass");
        if (!container.canCreateChildEntity(shapeType, template)) {
            return null;
        }
        Entity result = container.createChildEntity(shapeType, template);
        if (result == null) {
            return null;
        }
        clipboardElement.setObjectPropertyValue("$pastedElement", result);
        ClipboardElement[] ilinks = clipboardElement.getInboundLinks();
        if (ilinks != null) {
            int i = 0;
            while (i < ilinks.length) {
                ClipboardElement ilink = ilinks[i];
                if (ilink.isCut()) {
                    ilink.setCut(false);
                }
                this.pasteInboundLink(result, ilink);
                ++i;
            }
        }
        if ((children = clipboardElement.childEntities()) != null) {
            while (children.hasMoreElements()) {
                Entity next = children.next();
                if (!(next instanceof ClipboardElement)) continue;
                if (result.canSetObjectPropertyValue("$elementToClone", (Object)next)) {
                    result.setObjectPropertyValue("$elementToClone", (Object)next);
                    continue;
                }
                this.pasteHelper(result, (ClipboardElement)next, null, false);
            }
        }
        return result;
    }

    private void pasteInboundLink(Entity target, ClipboardElement ilink) {
        UniqueName sourceUin = ilink.getInboundLinkSource();
        if (sourceUin == null) {
            return;
        }
        Entity source = this.getModel().findEntity(sourceUin);
        if (source == null) {
            return;
        }
        Entity template = this.getModel().createEntityTemplate();
        template.setObjectPropertyValue("$pastedElement", (Object)target);
        template.setObjectPropertyValue("$elementToClone", (Object)ilink);
        String shapeType = ilink.getPropertyValue("$metaclass");
        if (!source.canCreateChildEntity(shapeType, template)) {
            return;
        }
        source.createChildEntity(shapeType, template);
    }
}

