/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.clipboard;

import com.tssap.j2ee.core.utils.clipboard.ClipboardElement;
import com.tssap.j2ee.core.utils.clipboard.ModelClipboard;
import com.tssap.selena.impl.model.elements.UniqueNameImpl;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public final class ClipboardView
extends ViewPart {
    public static final String UNKNOWN = "Unknown";
    private Tree myContents;

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 2048);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UniqueNameImpl uin = null;
                if (e.item instanceof TreeItem) {
                    String uins = ((TreeItem)e.item).getText();
                    System.out.println(uins);
                    try {
                        uin = new UniqueNameImpl(uins);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem item;
                    item.setExpanded(!(item = (TreeItem)e.item).getExpanded());
                }
            }
        });
        this.myContents = tree;
    }

    public void setFocus() {
        if (this.myContents == null) {
            return;
        }
        this.myContents.setFocus();
    }

    public void snapshot() {
        if (this.myContents == null) {
            return;
        }
        this.myContents.removeAll();
        CopyUniqueName[] contents = ModelClipboard.getContents();
        if (contents == null) {
            return;
        }
        int i = 0;
        while (i < contents.length) {
            this.addClipboardElement(null, ModelClipboard.getElement(contents[i]));
            ++i;
        }
    }

    private void addClipboardElement(TreeItem parent, ClipboardElement element) {
        EntityEnumeration children;
        ClipboardElement[] ilinks;
        TreeItem item = this.addItem(parent, "E", element.getUniqueName());
        PropertyEnumeration props = element.properties();
        if (props != null) {
            while (props.hasMoreElements()) {
                Property prop = props.next();
                this.addItem(item, "P", prop.getName() + "=" + prop.getValue());
            }
        }
        if ((ilinks = element.getInboundLinks()) != null) {
            int i = 0;
            while (i < ilinks.length) {
                this.addItem(item, "I", ilinks[i].getUniqueName());
                ++i;
            }
        }
        if ((children = element.children()) != null) {
            while (children.hasMoreElements()) {
                Entity child = children.next();
                if (child instanceof ClipboardElement) {
                    this.addClipboardElement(item, (ClipboardElement)child);
                    continue;
                }
                this.addItem(item, "UC", child);
            }
        }
        item.setExpanded(true);
    }

    private TreeItem addItem(TreeItem parent, String type, Object data) {
        TreeItem item = parent == null ? new TreeItem(this.myContents, 0) : new TreeItem(parent, 0);
        String text = data == null ? UNKNOWN : data.toString();
        item.setText(type + ": " + text);
        return item;
    }
}

