/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.EditorUtils;
import com.tssap.j2ee.core.utils.IDispatchSessionListener;
import com.tssap.j2ee.core.utils.IDispatchedJavaDeltaListener;
import com.tssap.j2ee.core.utils.ProjectDependencyCache;
import com.tssap.j2ee.internal.core.ejb.util.JavaDeltaDispatcher;
import com.tssap.j2ee.internal.core.ejb.util.ResourceDeltaDispatcher;
import com.tssap.j2ee.internal.core.ejb.workarounds.ProjectDependencyListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UtilsPlugin
extends Plugin {
    public static final String TRACE_DEBUG_OPTION = "/debug/trace";
    public static final String DELTA_DEBUG_OPTION = "/debug/delta";
    private static final String PROPERTIES_EP = "properties";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String FQN_GLUE = "/";
    private ProjectDependencyCache myProjectDependencyCache;
    private ResourceDeltaDispatcher myResourceDeltaDispatcher;
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static Map ourProperties;
    private static UtilsPlugin ourInstance;

    public UtilsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption(descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption(descriptor);
    }

    public static UtilsPlugin getDefault() {
        return ourInstance;
    }

    public void startup() throws CoreException {
        super.startup();
        JavaCore.addElementChangedListener((IElementChangedListener)JavaDeltaDispatcher.getInstance());
        this.myResourceDeltaDispatcher = new ResourceDeltaDispatcher();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.myResourceDeltaDispatcher);
        this.myProjectDependencyCache = new ProjectDependencyCache();
        this.addDispatchedResourceDeltaListener(this.myProjectDependencyCache);
        this.addDispatchedResourceDeltaListener(ProjectDependencyListener.getInstance());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                EditorUtils.register();
            }
        });
    }

    public void shutdown() throws CoreException {
        EditorUtils.unregister();
        JavaCore.removeElementChangedListener((IElementChangedListener)JavaDeltaDispatcher.getInstance());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.myResourceDeltaDispatcher);
        this.removeDispatchedResourceDeltaListener(ProjectDependencyListener.getInstance());
        this.removeDispatchedResourceDeltaListener(this.myProjectDependencyCache);
        super.shutdown();
    }

    public static Shell getActiveShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        return display.getActiveShell();
    }

    public static boolean references(IProject p1, IProject p2) {
        IProject[] refProjects = null;
        try {
            refProjects = p1.getReferencedProjects();
        }
        catch (CoreException ce) {
            // empty catch block
        }
        if (refProjects == null || refProjects.length == 0) {
            return false;
        }
        int i = 0;
        while (i < refProjects.length) {
            IProject refProject = refProjects[i];
            if (refProject != null && p2.getName().equals(refProject.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ProjectDependencyCache getProjectDependencyCache() {
        return this.myProjectDependencyCache;
    }

    public void addDispatchedJavaDeltaListener(IDispatchedJavaDeltaListener listener, IJavaElement target) {
        JavaDeltaDispatcher.getInstance().addDispatchedDeltaListener(target, listener);
    }

    public void removeDispatchedJavaDeltaListener(IDispatchedJavaDeltaListener listener, IJavaElement target) {
        JavaDeltaDispatcher.getInstance().removeDispatchedDeltaListener(target, listener);
    }

    public void addDispatchSessionListener(IDispatchSessionListener listener) {
        JavaDeltaDispatcher.getInstance().addDispatchSessionListener(listener);
    }

    public void removeDispatchSessionListener(IDispatchSessionListener listener) {
        JavaDeltaDispatcher.getInstance().removeDispatchSessionListener(listener);
    }

    public void addDispatchedResourceDeltaListener(IResourceChangeListener listener) {
        this.myResourceDeltaDispatcher.addDispatchedDeltaListener(listener);
    }

    public void removeDispatchedResourceDeltaListener(IResourceChangeListener listener) {
        this.myResourceDeltaDispatcher.removeDispatchedDeltaListener(listener);
    }

    private static void readProperties() {
        if (ourProperties != null) {
            return;
        }
        UtilsPlugin.logInfo("Reading properties");
        ourProperties = new HashMap();
        IExtensionPoint extPoint = UtilsPlugin.getDefault().getDescriptor().getExtensionPoint(PROPERTIES_EP);
        IExtension[] extensions = extPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String pluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (!PROPERTY_TAG.equals(element.getName())) {
                    UtilsPlugin.logWarning("Properties extension point in plugin [" + pluginId + "] contains unknown tag: " + element.getName());
                } else {
                    String name = element.getAttribute(NAME_ATTRIBUTE);
                    if (name == null) {
                        UtilsPlugin.logWarning("Property is declared in plugin [" + pluginId + "] without a name");
                    } else {
                        name = pluginId + FQN_GLUE + name;
                        String value = element.getAttribute(VALUE_ATTRIBUTE);
                        if (value == null) {
                            value = "";
                        }
                        ourProperties.put(name, value);
                        UtilsPlugin.logInfo(name + "=" + value);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static String getProperty(IPluginDescriptor descriptor, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        name = descriptor.getUniqueIdentifier() + FQN_GLUE + name;
        UtilsPlugin.readProperties();
        return (String)ourProperties.get(name);
    }

    public static boolean getDebugOption(IPluginDescriptor descriptor, String name) {
        String key = descriptor.getUniqueIdentifier() + name;
        String value = Platform.getDebugOption((String)key);
        return Boolean.valueOf(value);
    }

    public static boolean getTraceDebugOption(IPluginDescriptor descriptor) {
        return UtilsPlugin.getDebugOption(descriptor, TRACE_DEBUG_OPTION);
    }

    public static boolean getDeltaDebugOption(IPluginDescriptor descriptor) {
        return UtilsPlugin.getDebugOption(descriptor, DELTA_DEBUG_OPTION);
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        UtilsPlugin instance = UtilsPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        UtilsPlugin.log(1, text);
    }

    public static void logError(String text) {
        UtilsPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        UtilsPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        UtilsPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        UtilsPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        UtilsPlugin instance = UtilsPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            UtilsPlugin.log(type, text, new Throwable());
        } else {
            UtilsPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        UtilsPlugin instance = UtilsPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

