/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    public static final String ESCAPED_SPACE = "%20";
    public static final String WHITESPACE = " \t\n\r\f";

    private StringUtils() {
    }

    public static String escape(String s) {
        return StringUtils.escape(s, ' ', ESCAPED_SPACE);
    }

    public static String escape(String s, char c, String subs) {
        if (s == null || s.length() == 0 || subs == null) {
            return s;
        }
        int j = s.indexOf(c);
        if (j < 0) {
            return s;
        }
        int subsLen = subs.length();
        StringBuffer sb = new StringBuffer(s.length() * (subsLen == 0 ? 1 : subsLen));
        int i = 0;
        while (j >= 0) {
            sb.append(s.substring(i, j));
            if (subsLen > 0) {
                sb.append(subs);
            }
            i = j + 1;
            j = s.indexOf(c, i);
        }
        sb.append(s.substring(i));
        return sb.toString();
    }

    public static String unescape(String s) {
        return StringUtils.unescape(s, ESCAPED_SPACE, ' ');
    }

    public static String unescape(String s, String subs, char c) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int j = s.indexOf(subs);
        if (j < 0) {
            return s;
        }
        int subsLen = subs.length();
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (j >= 0) {
            sb.append(s.substring(i, j));
            sb.append(c);
            i = j + subsLen;
            j = s.indexOf(subs, i);
        }
        sb.append(s.substring(i));
        return sb.toString();
    }
}

