/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.property.element.GenericElementProperty;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringArrayProperty
extends GenericElementProperty {
    public static final String UNSPECIFIED = "*";

    public Object getValue() {
        if (this.getObject() == null) {
            return null;
        }
        String[] array = (String[])((Element)this.getObject()).getObjectPropertyValue(this.getModelPropertyName());
        if (array == null) {
            return UNSPECIFIED;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            String element;
            if (value.length() > 0) {
                value.append(", ");
            }
            if ((element = array[i]) != null) {
                value.append(element);
            }
            ++i;
        }
        return value.toString();
    }

    public void setValue(Object value) {
        if (this.getObject() == null) {
            return;
        }
        ((Element)this.getObject()).setObjectPropertyValue(this.getModelPropertyName(), (Object)this.toArray((String)value));
    }

    public String isValidValue(Object value) {
        if (value instanceof String || value == null) {
            return ((Element)this.getObject()).canSetObjectPropertyValue(this.getModelPropertyName(), (Object)this.toArray((String)value)) ? null : Messages.getString("StringArrayProperty.UnableToSetValue");
        }
        return Messages.getString("StringArrayProperty.IncorrectValue");
    }

    private String[] toArray(String value) {
        if (value == null || UNSPECIFIED.equals(value)) {
            return null;
        }
        if (value.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String element = st.nextToken().trim();
            list.add(element);
            if (element.length() != 0) continue;
            list.set(list.size() - 1, null);
        }
        return list.toArray(new String[list.size()]);
    }
}

