/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class StringArrayList
extends ArrayList {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final StringArrayList EMPTY_LIST = new StringArrayList(){

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return false;
        }

        public int size() {
            return 0;
        }

        public int indexOf(Object o) {
            return -1;
        }

        public int lastIndexOf(Object o) {
            return -1;
        }

        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        public void ensureCapacity(int minCapacity) {
        }

        public void trimToSize() {
        }
    };

    public StringArrayList() {
    }

    public StringArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public StringArrayList(Collection c) {
        this.addAll(c);
    }

    public StringArrayList(StringArrayList c) {
        super.addAll(c);
    }

    public StringArrayList(String values) {
        super(StringArrayList.getValuesAsList(values, ",", -1));
    }

    public StringArrayList(String values, String delimiters) {
        super(StringArrayList.getValuesAsList(values, delimiters, -1));
    }

    public StringArrayList(String values, String delimiters, int stopAfter) {
        super(StringArrayList.getValuesAsList(values, delimiters, stopAfter));
    }

    public StringArrayList(StringTokenizer tokens) {
        super(StringArrayList.getValuesAsList(tokens));
    }

    public static StringArrayList getValuesAsList(String values, String delimiters, int stopAfter) {
        if (values == null || values.length() == 0) {
            return EMPTY_LIST;
        }
        if (stopAfter < 0) {
            stopAfter = Integer.MAX_VALUE;
        }
        StringArrayList c = new StringArrayList();
        int i = 0;
        while (i < stopAfter) {
            int p = StringArrayList.getNearestIndexOf(values, delimiters);
            if (p < 0) break;
            String value = values.substring(0, p).trim();
            values = values.substring(p + 1);
            if (value.length() > 0) {
                c.add(value);
            }
            ++i;
        }
        values = values.trim();
        if (values.length() > 0) {
            c.add(values);
        }
        return c;
    }

    protected static int getNearestIndexOf(String s, String delimiters) {
        if (s == null || s.length() == 0 || delimiters == null || delimiters.length() == 0) {
            return -1;
        }
        int delimitersCount = delimiters.length();
        if (delimitersCount == 1) {
            return s.indexOf(delimiters.charAt(0));
        }
        int p = -1;
        int i = 0;
        while (i < delimitersCount) {
            int c = s.indexOf(delimiters.charAt(i));
            if (c >= 0 && (p == -1 || c < p)) {
                p = c;
            }
            ++i;
        }
        return p;
    }

    public static StringArrayList getValuesAsList(StringTokenizer tokens) {
        if (tokens == null || !tokens.hasMoreTokens()) {
            return EMPTY_LIST;
        }
        StringArrayList c = new StringArrayList();
        while (tokens.hasMoreTokens()) {
            c.add(tokens.nextToken());
        }
        return c;
    }

    public String[] toStringArray() {
        if (this.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return this.toArray(new String[this.size()]);
    }

    public String getString(int i) {
        return (String)this.get(i);
    }

    public Object get(int arg0) {
        try {
            return super.get(arg0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean add(Object element) {
        this.checkObject(element);
        return super.add(element);
    }

    public void add(int index, Object element) {
        this.checkObject(element);
        super.add(index, element);
    }

    public Object set(int index, Object element) {
        this.checkObject(element);
        return super.set(index, element);
    }

    public boolean addAll(Collection c) {
        this.checkCollection(c);
        return super.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.checkCollection(c);
        return super.addAll(index, c);
    }

    protected void checkCollection(Collection c) {
        if (c == null) {
            return;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.checkObject(i.next());
        }
    }

    protected void checkObject(Object o) {
        if (o == null || o instanceof String) {
            return;
        }
        throw new IllegalArgumentException(o.toString());
    }

    public String toString() {
        return this.toString(", ");
    }

    public String toString(String glue) {
        if (this.isEmpty()) {
            return "";
        }
        int maxIndex = this.size();
        StringBuffer buf = new StringBuffer(16 * maxIndex);
        --maxIndex;
        int i = 0;
        while (i <= maxIndex) {
            Object oi = this.get(i);
            if (oi != null) {
                buf.append(oi.toString());
                if (i < maxIndex) {
                    buf.append(glue);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static class Unmodifiable
    extends StringArrayList {
        public Unmodifiable(StringArrayList source) {
            super(source);
        }

        protected void checkObject(Object o) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

