/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;

public class ReadOnlinessValidator {
    private HashSet myResources = new HashSet();
    private boolean myHaveBinaryJavaElements;

    public ReadOnlinessValidator() {
    }

    public ReadOnlinessValidator(IFile[] files) {
        this.addResources(files);
    }

    public ReadOnlinessValidator(IMember[] members) {
        this.addJavaElements(members);
    }

    public void addResource(IFile resource) {
        this.myResources.add(resource);
    }

    public void addResources(IFile[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addResource(resources[i]);
            ++i;
        }
    }

    public void addJavaElement(IMember element) {
        if (element == null) {
            return;
        }
        if (element.isBinary()) {
            this.myHaveBinaryJavaElements = true;
            return;
        }
        ICompilationUnit cu = element.getCompilationUnit();
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        this.myResources.add(cu.getResource());
    }

    public void addJavaElements(IMember[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.addJavaElement(elements[i]);
            ++i;
        }
    }

    public boolean canModify() {
        if (this.myHaveBinaryJavaElements) {
            return false;
        }
        ArrayList resources = new ArrayList(this.myResources);
        Iterator it = ((AbstractList)resources).iterator();
        while (it.hasNext()) {
            IFile file = (IFile)it.next();
            if (file != null && file.isReadOnly()) continue;
            it.remove();
        }
        if (resources.isEmpty()) {
            return true;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(resources.toArray(new IFile[resources.size()]), (Object)UtilsPlugin.getActiveShell());
        return status.isOK();
    }
}

