/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.IProjectDependencyListener;
import com.tssap.j2ee.core.utils.ParametrizedHashBag;
import com.tssap.j2ee.core.utils.ProjectDeltaUtils;
import com.tssap.j2ee.core.utils.ProjectDependencyChangeEvent;
import com.tssap.j2ee.core.utils.ProjectDependencyDeltaInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ProjectDependencyCache
implements IResourceChangeListener {
    private ParametrizedHashBag myProjectTree;
    private ParametrizedHashBag myFlattenedProjectTree;
    private ParametrizedHashBag myFlattenedBackwardProjectTree;
    private HashSet myListeners = new HashSet();
    static /* synthetic */ Class class$java$util$HashSet;

    public ProjectDependencyCache() {
        this.buildProjectDependencyTree();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.projectHierarchyMayHaveChanged(event.getDelta())) {
            this.rebuildProjectDependencyTree();
        }
    }

    private boolean projectHierarchyMayHaveChanged(IResourceDelta delta) {
        try {
            ProjectHierarchyVisitor visitor = new ProjectHierarchyVisitor();
            delta.accept((IResourceDeltaVisitor)visitor);
            return visitor.projectHierarchyMayHaveChanged();
        }
        catch (CoreException e) {
            return false;
        }
    }

    public Collection getAllReferencedProjects(IProject project) {
        return this.myFlattenedProjectTree.get(project);
    }

    public Collection getAllReferencingProjects(IProject project) {
        return this.myFlattenedBackwardProjectTree.get(project);
    }

    public void rebuildProjectDependencyTree() {
        ParametrizedHashBag oldFlattenedBackwardProjectTree = this.myFlattenedBackwardProjectTree;
        this.buildProjectDependencyTree();
        HashMap<IProject, ProjectDependencyDeltaInfo> deltaInfos = new HashMap<IProject, ProjectDependencyDeltaInfo>();
        HashSet allKeys = new HashSet(oldFlattenedBackwardProjectTree.keySet());
        allKeys.addAll(this.myFlattenedBackwardProjectTree.keySet());
        Iterator it = allKeys.iterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            ProjectDependencyDeltaInfo info = new ProjectDependencyDeltaInfo(next);
            info.merge(oldFlattenedBackwardProjectTree.safeGet(next), this.myFlattenedBackwardProjectTree.safeGet(next));
            if (info.isEmpty()) continue;
            deltaInfos.put(next, info);
        }
        if (!deltaInfos.isEmpty()) {
            this.fire(deltaInfos);
        }
    }

    private void fire(HashMap deltaInfos) {
        ProjectDependencyChangeEvent evt = new ProjectDependencyChangeEvent(this, deltaInfos);
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                IProjectDependencyListener next = (IProjectDependencyListener)it.next();
                next.projectDependencyChanged(evt);
            }
        }
    }

    private void buildProjectDependencyTree() {
        this.myProjectTree = new ParametrizedHashBag(class$java$util$HashSet == null ? (class$java$util$HashSet = ProjectDependencyCache.class$("java.util.HashSet")) : class$java$util$HashSet);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject next = projects[i];
            this.buildProjectDependencyTree(next);
            ++i;
        }
        this.flattenProjectTree();
        this.buildBackwardProjectTree();
        int i2 = 0;
        while (i2 < projects.length) {
            this.myFlattenedProjectTree.add(projects[i2], projects[i2]);
            this.myFlattenedBackwardProjectTree.add(projects[i2], projects[i2]);
            ++i2;
        }
    }

    private void buildProjectDependencyTree(IProject project) {
        IProject[] referenced;
        if (this.myProjectTree.containsKey(project) || !project.isAccessible()) {
            return;
        }
        try {
            referenced = project.getReferencedProjects();
        }
        catch (CoreException e) {
            referenced = new IProject[]{};
        }
        int i = 0;
        while (i < referenced.length) {
            IProject next = referenced[i];
            if (next.isAccessible()) {
                this.myProjectTree.add(project, next);
                this.buildProjectDependencyTree(next);
            }
            ++i;
        }
    }

    private void flattenProjectTree() {
        this.myFlattenedProjectTree = new ParametrizedHashBag(class$java$util$HashSet == null ? (class$java$util$HashSet = ProjectDependencyCache.class$("java.util.HashSet")) : class$java$util$HashSet);
        Iterator it = this.myProjectTree.keyIterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            this.flattenProjectTree(next);
        }
    }

    private void flattenProjectTree(IProject project) {
        this.flattenProjectTree(project, project, new HashSet());
    }

    private void flattenProjectTree(IProject recipient, IProject root, HashSet processedSubRoots) {
        if (processedSubRoots.contains(root)) {
            return;
        }
        processedSubRoots.add(root);
        this.myFlattenedProjectTree.add(recipient, root);
        Iterator it = this.myProjectTree.safeGet(root).iterator();
        while (it.hasNext()) {
            IProject nextRoot = (IProject)it.next();
            this.flattenProjectTree(recipient, nextRoot, processedSubRoots);
        }
    }

    private void buildBackwardProjectTree() {
        this.myFlattenedBackwardProjectTree = new ParametrizedHashBag(class$java$util$HashSet == null ? (class$java$util$HashSet = ProjectDependencyCache.class$("java.util.HashSet")) : class$java$util$HashSet);
        Iterator it = this.myFlattenedProjectTree.keyIterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            Iterator it1 = this.myFlattenedProjectTree.get(next).iterator();
            while (it1.hasNext()) {
                IProject nextDependency = (IProject)it1.next();
                this.myFlattenedBackwardProjectTree.add(nextDependency, next);
            }
        }
    }

    public void addProjectDependencyListener(IProjectDependencyListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.add(listener);
        }
    }

    public void removeProjectDependencyListener(IProjectDependencyListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.remove(listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProjectHierarchyVisitor
    implements IResourceDeltaVisitor {
        private boolean myDescriptionChanged;

        private ProjectHierarchyVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    if (ProjectDeltaUtils.isProjectBeingClosed(delta) || ProjectDeltaUtils.isProjectBeingOpened(delta) || ProjectDeltaUtils.isProjectDescriptionChanged(delta)) {
                        this.myDescriptionChanged = true;
                    }
                    return false;
                }
                default: {
                    return false;
                }
                case 1: 
            }
            return false;
        }

        public boolean projectHierarchyMayHaveChanged() {
            return this.myDescriptionChanged;
        }
    }
}

